/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;

public final class GitFileLocationFormatter {
    private GitFileLocationFormatter() {
    }

    public static String format(@Nonnull Repository repository, @Nonnull String path) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)path);
        Server server = repository.getServer();
        StringBuilder sb = new StringBuilder();
        sb.append(server.getConnectionProtocol().toPrefix());
        sb.append(server.getHost());
        if (server.getPort() != null) {
            sb.append(":");
            sb.append(server.getPort());
        }
        sb.append(repository.getPath());
        sb.append("/");
        sb.append(path);
        return sb.toString();
    }
}

