(function ($) {

    $.fn.gitRepositoryFileAutocompleter = function (options) {
        var cache = [];
        var lastQuery = {};
        var $element = this;
        var fittingCharacters = function () {
            return ($element.parent().width() / 10);
        };

        var settings = $.extend({
            repository: function () {
                $.error("the repository: fn() argument is required");
            },
            branch: function () {
                return "master";
            },
            commitId: function () {
                return "";
            }
        }, options);


        $element.auiSelect2({
            placeholder: AJS.I18n.getText("gitplugin.attachment.dialog.path.select"),
            minimumInputLength: 0,
            width: "100%",
            closeOnSelect: false,
            adaptContainerCssClass: function (clazz) {
                // filter out macro-param-input for macro browser issues
                if (clazz === "macro-param-input") {
                    return null
                }
                return clazz;
            },
            sortResults: function (results, container, query) {
                return _.sortBy(results, function (result) {
                    return result.text;
                });
            },
            query: function (query) {
                var term = query.term;

                var regResult = /(.*)\/(.*)$/.exec(term);

                var term = "";
                if (regResult !== null) {
                    var term = regResult[1];
                }

                var newQuery = {
                    "branch": settings.branch().trim(),
                    "path": term,
                    "commitId": settings.commitId()
                };


                if (_.isEqual(lastQuery, newQuery)) {
                    var lowerCaseQuery = query.term.toLowerCase();

                    var results = _.filter(cache, function (result) {
                        return result.text.toLowerCase().indexOf(lowerCaseQuery) !== -1;
                    });

                    query.callback({results: results});
                    return;
                }

                AJS.$.ajax({
                    url: AJS.contextPath() + "/rest/git-plugin/1.0/repositories/" + settings.repository() + "/files",
                    dataType: 'json',
                    cache: false,
                    data: newQuery,
                    error: function (xhr) {
                        query.callback({results: []});
                    },
                    success: function (filePaths) {
                        var fittingChars = fittingCharacters();
                        var results = [];
                        for (var i = 0; i < filePaths.length; i++) {
                            results.push({id: filePaths[i], text: filePaths[i]});
                        }

                        // Do not display sub directories
                        for (var i = 0; i < results.length; i++) {
                            results[i].text = results[i].text.replace(/^.*(\/.*.$)/, '..$1');
                        }

                        cache = results;
                        lastQuery = newQuery;
                        query.callback({results: results});
                    }
                });
            }
        });

        // open folder when selecting one
        $element.on("select2-selecting", function (e) {
            // If its a folder
            if (/\/$/.test(e.val)) {
                e.preventDefault();

                // Open the folder
                $element.auiSelect2("open");
                AJS.$("#select2-drop .select2-search input.select2-input")
                    .val(e.val)
                    .trigger("paste");
            }
        });

        if (!_.isEmpty(settings.initialValue)) {
            $element.auiSelect2("data", {id: settings.initialValue, text: settings.initialValue});
        }

        return this;
    }

}(AJS.$));
