(function($) {

  $.fn.gitPluginBranchSelect = function(options) {
    var cache = {};
    var $element = this;

    var settings = $.extend({
      repository : function() {
        $.error("the repository: fn() argument is required");
      }
    }, options);


    $element.auiSelect2({
      placeholder : AJS.I18n.getText("gitplugin.attachment.dialog.branch.select"),
      minimumInputLength : 0,
      width : "100%",
      closeOnSelect : false,
      dropdownCssClass : "git-plugin-show-full-select2-option",
      adaptContainerCssClass : function(clazz) {
        // filter out macro-param-input for macro browser issues
        if (clazz === "macro-param-input") {
          return null
        }
        return clazz;
      },
      sortResults : function(results, container, query) {
        if (query.term) {
          return results.sort(function(a, b) {
            if (a.text.toLowerCase().indexOf(query.term.toLowerCase()) < b.text.toLowerCase().indexOf(query.term.toLowerCase())) {
              return 1;
            } else if (a.text.toLowerCase().indexOf(query.term.toLowerCase()) > b.text.toLowerCase().indexOf(query.term.toLowerCase())) {
              return -1;
            } else {
              return 0;
            }
          });
        }

        return results;
      },
      query : function(query) {
        var repository = settings.repository();
        if (_.isEmpty(repository)) {
          query.callback({results : []});
        } else if (cache[repository] !== undefined) {
          query.callback({results : cache[repository]});
        } else {
          AJS.$.ajax({
            url : AJS.contextPath() + "/rest/git-plugin/1.0/repositories/" + repository + "/branches-and-tags-autocomplete",
            dataType : 'json',
            cache : false,
            success : function(branches) {
              query.callback(branches);
            },
            error : function() {
              query.callback({results : []});
            }
          });
        }
      }
    });

    if (!_.isEmpty(settings.initialValue)) {
      $element.auiSelect2("data", {id : settings.initialValue, text : settings.initialValue});
    }

    return this;
  }

}(AJS.$));
