/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLastIndexedTimestamp
implements ActiveObjectsUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(AddLastIndexedTimestamp.class);
    private final VCSRepositoryManager repositoryManager;

    public AddLastIndexedTimestamp(@Nonnull VCSRepositoryManager repositoryManager) {
        this.repositoryManager = (VCSRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"100500304");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        LOG.warn("Starting AddLastIndexedTimestamp upgrade task");
        ao.migrate(new Class[]{Repository.class});
        Repository[] repositories = (Repository[])ao.find(Repository.class);
        LOG.warn("Will update {} repositories", (Object)repositories.length);
        Arrays.stream(repositories).forEach(repository -> {
            try {
                Long lastIndexedTimestamp = this.repositoryManager.getLastCommitTimeStamp(repository);
                repository.setLastIndexedTimestamp(lastIndexedTimestamp);
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while adding lastIndexedCommitId to repository={}", (Object)repository.getID(), (Object)e);
            }
        });
        LOG.warn("Updated {} repositories", (Object)repositories.length);
        LOG.warn("Done with AddLastIndexedTimestamp upgrade task");
    }
}

