/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.progress;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.progress.TaskProgress;

@Named
public class TaskProgressStore {
    private final Map<Integer, TaskProgress> progress = new HashMap<Integer, TaskProgress>();

    public void beginTask(Repository repository, String taskName, int totalWork) {
        this.progress.put(repository.getID(), new TaskProgress(taskName, totalWork, 0, new RestRepository(repository)));
    }

    public void update(Repository repository, String taskName, int completedWork, int totalWork) {
        this.progress.put(repository.getID(), new TaskProgress(taskName, totalWork, completedWork, new RestRepository(repository)));
    }

    public void end(Repository repository) {
        this.progress.remove(repository.getID());
    }

    public Map<Integer, TaskProgress> get(final Integer serverId) {
        Map filtered = Maps.filterValues(this.progress, (Predicate)new Predicate<TaskProgress>(){

            public boolean apply(TaskProgress taskProgress) {
                return taskProgress.getRepository().getServerId() == serverId;
            }
        });
        return filtered;
    }
}

