/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git;

import nl.avisi.confluence.plugins.gitplugin.core.Server;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class GitPluginSshCredentialsProvider
extends CredentialsProvider {
    Server server;

    public GitPluginSshCredentialsProvider(Server server) {
        this.server = server;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.StringType) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem item : items) {
            if (!(item instanceof CredentialItem.StringType)) continue;
            this.handleStringTypeCredentialItem(this.server, (CredentialItem.StringType)item);
        }
        return true;
    }

    private void handleStringTypeCredentialItem(Server server, CredentialItem.StringType item) {
        if (server.getConnectionProtocol().equals((Object)Server.ConnectionProtocol.SSH)) {
            item.setValue(server.getPassword());
        }
    }
}

