/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git;

import com.google.common.base.Charsets;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.git.GitPluginSshCredentialsProvider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.internal.transport.ssh.jsch.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class CredentialsConfigurationSessionFactory
extends JschConfigSessionFactory {
    Server server;

    public CredentialsConfigurationSessionFactory(Server server) {
        this.server = server;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, (CredentialsProvider)new GitPluginSshCredentialsProvider(this.server));
        session.setUserInfo((UserInfo)userInfo);
        session.setConfig("StrictHostKeyChecking", "no");
    }

    protected JSch getJSch(OpenSshConfig.Host host, FS fileSystem) throws JSchException {
        JSch jSch = this.createDefaultJsch(host, fileSystem);
        if (StringUtils.isBlank((CharSequence)this.server.getSshKey())) {
            return jSch;
        }
        byte[] password = this.getPassword(this.server);
        String sshKey = this.getSshKeyPath(fileSystem, this.server);
        jSch.removeAllIdentity();
        jSch.addIdentity(sshKey, password);
        return jSch;
    }

    protected JSch createDefaultJsch(OpenSshConfig.Host host, FS fileSystem) throws JSchException {
        return super.getJSch(host, fileSystem);
    }

    private String getSshKeyPath(FS fileSystem, Server server) throws JSchException {
        String sshKey = server.getSshKey();
        if (StringUtils.substring((String)StringUtils.strip((String)sshKey), (int)0, (int)1).equals("~")) {
            sshKey = new File(fileSystem.userHome(), sshKey.replace("~/", "")).getAbsolutePath();
        }
        if (!new File(sshKey).exists()) {
            throw new JSchException(String.format("Could not find the SSH key file on %s", sshKey));
        }
        return sshKey;
    }

    private byte[] getPassword(Server server) {
        byte[] password = StringUtils.isBlank((CharSequence)server.getPassword()) ? new byte[]{} : server.getPassword().getBytes(Charsets.UTF_8);
        return password;
    }
}

