/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import org.codehaus.jackson.annotate.JsonCreator;

public class RestRepository {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private int id;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private String name;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private String path;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private String serverName;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private Integer serverId;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private Date lastSynchronized;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private boolean archived;

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    public RestRepository(@JsonProperty(value="name") @org.codehaus.jackson.annotate.JsonProperty(value="name") String name, @JsonProperty(value="path") @org.codehaus.jackson.annotate.JsonProperty(value="path") String path) {
        this.name = name;
        this.path = path;
    }

    public RestRepository(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        this.id = repository.getID();
        this.name = repository.getName();
        this.path = repository.getPath();
        this.lastSynchronized = repository.getLastSynchronized();
        this.archived = repository.isArchived();
        this.serverName = repository.getServer().getName();
        this.serverId = repository.getServer().getID();
    }

    public static Collection<RestRepository> collection(Collection<? extends Repository> repositories) {
        return Collections2.transform(repositories, (Function)new Transformer());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastSynchronized() {
        return this.lastSynchronized;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public String getPath() {
        return this.path;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Integer getServerId() {
        return this.serverId;
    }

    public static class Transformer
    implements Function<Repository, RestRepository> {
        @Nullable
        public RestRepository apply(@Nullable Repository repository) {
            return new RestRepository(repository);
        }
    }
}

