/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.attachment.listener;

import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.attachment.dao.GitAttachmentDao;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.git.jobs.PullJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class AttachmentEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullJob.class);
    @ConfluenceImport
    private final EventPublisher eventPublisher;
    private final GitAttachmentDao gitAttachmentDao;

    @Inject
    public AttachmentEventListener(@ComponentImport EventPublisher eventPublisher, GitAttachmentDao gitAttachmentDao) {
        this.eventPublisher = eventPublisher;
        this.gitAttachmentDao = gitAttachmentDao;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Register AttachmentEventListener");
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onAttachmentRemoved(AttachmentRemoveEvent attachmentRemoveEvent) {
        LOGGER.debug("On attachment removed id={}", (Object)attachmentRemoveEvent.getAttachment().getId());
        Optional<GitAttachment> optional = this.gitAttachmentDao.get(attachmentRemoveEvent.getAttachment().getId());
        if (optional.isPresent()) {
            LOGGER.debug("On attachment removed id={} is gitAttachment is present en will be deleted", (Object)attachmentRemoveEvent.getAttachment().getId());
            this.gitAttachmentDao.delete(optional.get());
        }
    }

    public void destroy() throws Exception {
        LOGGER.debug("Unregister AttachmentEventListener");
        this.eventPublisher.unregister((Object)this);
    }
}

