define('GFC/autoConverter', ['tinymce'], function (tinymce) {
    "use strict";

    function autoConverter() {
        function pasteHandler(uri, node, done) {
            const uriSource = decodeURIComponent(uri.source); //prevents issues if the user used special characters in the naming of branch or path/ file. for example the use of '#'.
            AJS.$.ajax({
                url: AJS.contextPath() + "/rest/git-plugin/1.0/servers/by-host",
                dataType: 'json',
                data: {"urlHost": uri.host},
                cache: false,
                success: function (serverId) {
                    var urlSplit = uriSource.split("/");
                    var data = "/" + urlSplit[3] + "/" + urlSplit[4] + ".git";
                    AJS.$.ajax({
                        url: AJS.contextPath() + "/rest/git-plugin/1.0/repositories/by-path",
                        dataType: 'json',
                        cache: false,
                        data: {"repositoryPath": data},
                        success: function (repositoryId) {
                            AJS.$.ajax({
                                url: AJS.contextPath() + "/rest/git-plugin/1.0/repositories/" + repositoryId + "/collect-macro-information",
                                dataType: 'json',
                                cache: false,
                                data: {
                                    "uriSource": uriSource
                                },
                                success: function (data) {
                                    var formData = {
                                        "repository-id": repositoryId,
                                        "branch": data["branch"],
                                        "path": data["path"],
                                        "commit-id": data["commitId"],
                                    };
                                    var macroRenderRequest = {
                                        contentId: Confluence.Editor.getContentId(),
                                        macro: {
                                            name: "view-git-file",
                                            params: formData,
                                            defaultParameterValue: "",
                                            body: ""
                                        }
                                    }
                                    done(tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest));
                                },
                                error: function () {
                                    console.error("Error: loading file information.");
                                    done();
                                }
                            });
                        },
                        error: function (e) {
                            if (e.status == 404) {
                                console.error("Error: " + e.status + " No matching repository was found");
                            } else {
                                console.error("Error: " + e.status + " loading repository information");
                            }

                            done();
                        }
                    });
                },
                error: function (e) {
                    if (e.status == 404) {
                        console.error("Error: " + e.status + " No matching server was found");
                    } else {
                        console.error("Error: " + e.status + " loading server information");
                    }
                    done();
                }
            });
        }

        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return autoConverter;
});
require('confluence/module-exporter').safeRequire('GFC/autoConverter', function (autoConverter) {
    require('ajs').bind("init.rte", autoConverter);
});
