/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.providers;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.GitAddonException;

@Named
public class LocalDirectoryProvider {
    private final BootstrapManager bootstrapManager;
    private final ClusterManager clusterManager;
    private static final String ROOT = "avisi-git-plugin-repositories";

    @Inject
    public LocalDirectoryProvider(@ComponentImport BootstrapManager bootstrapManager, @ComponentImport ClusterManager clusterManager) {
        this.bootstrapManager = (BootstrapManager)Preconditions.checkNotNull((Object)bootstrapManager);
        this.clusterManager = (ClusterManager)Preconditions.checkNotNull((Object)clusterManager);
    }

    public File getLocalDirectory(Repository repository) {
        File serverDirectory = this.getLocalDirectory(repository.getServer());
        if (this.isFileBasedServer(repository.getServer())) {
            return new File(serverDirectory, repository.getPath());
        }
        String repositoryId = String.valueOf(repository.getID());
        return new File(serverDirectory, repositoryId);
    }

    public File getLocalDirectory(Server server) {
        if (this.isFileBasedServer(server)) {
            if (this.clusterManager.isClustered()) {
                throw new GitAddonException("The file protocol is not supported on clustered Confluence environments");
            }
            return new File(server.getHost());
        }
        String serverId = String.valueOf(server.getID());
        File pluginDirectory = new File(this.getHomeDirectory(), ROOT);
        return new File(pluginDirectory, serverId);
    }

    private boolean isFileBasedServer(Server server) {
        return Server.ConnectionProtocol.FILE.equals((Object)server.getConnectionProtocol());
    }

    public File getPluginRootDirectory() {
        return new File(this.getHomeDirectory(), ROOT);
    }

    private File getHomeDirectory() {
        if (this.clusterManager.isClustered()) {
            return this.bootstrapManager.getSharedHome();
        }
        return this.bootstrapManager.getLocalHome();
    }
}

