/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.progress;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.progress.TaskProgressStore;
import org.eclipse.jgit.lib.EmptyProgressMonitor;

public class TaskProgressMonitor
extends EmptyProgressMonitor {
    private final Repository repository;
    private final TaskProgressStore taskProgressStore;
    private String currentTask;
    private int totalWork;
    private int completedWork = 0;

    public TaskProgressMonitor(@Nonnull Repository repository, @Nonnull TaskProgressStore taskProgressStore) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.taskProgressStore = (TaskProgressStore)Preconditions.checkNotNull((Object)taskProgressStore);
    }

    public void beginTask(String currentTask, int totalWork) {
        this.currentTask = currentTask;
        this.totalWork = totalWork;
        this.completedWork = 0;
        this.taskProgressStore.beginTask(this.repository, currentTask, totalWork);
    }

    public void endTask() {
        this.taskProgressStore.end(this.repository);
    }

    public void update(int completed) {
        this.completedWork += completed;
        this.taskProgressStore.update(this.repository, this.currentTask, this.completedWork, this.totalWork);
    }
}

