/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.manager;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.I18nMessage;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.CommitInformation;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.GitInformation;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.BranchNotFoundException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.GitFileNotFoundException;
import nl.avisi.confluence.plugins.gitplugin.git.CredentialsProviderFactory;
import nl.avisi.confluence.plugins.gitplugin.git.FileDetails;
import nl.avisi.confluence.plugins.gitplugin.git.exception.ListRepositoryBranchesException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryUpdateException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.git.progress.TaskProgressMonitor;
import nl.avisi.confluence.plugins.gitplugin.git.progress.TaskProgressStore;
import nl.avisi.confluence.plugins.gitplugin.git.providers.LocalDirectoryProvider;
import nl.avisi.confluence.plugins.gitplugin.git.providers.RepositoryUrlProvider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class GitRepositoryManager
implements VCSRepositoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitRepositoryManager.class);
    private final LocalDirectoryProvider directoryProvider;
    private final RepositoryUrlProvider repositoryUrlProvider;
    private final CredentialsProviderFactory credentialsProviderFactory;
    private final TaskProgressStore taskProgressStore;

    @Inject
    public GitRepositoryManager(@Nonnull LocalDirectoryProvider directoryProvider, @Nonnull RepositoryUrlProvider repositoryUrlProvider, @Nonnull CredentialsProviderFactory credentialsProviderFactory, @Nonnull TaskProgressStore taskProgressStore) {
        this.directoryProvider = (LocalDirectoryProvider)Preconditions.checkNotNull((Object)directoryProvider);
        this.repositoryUrlProvider = (RepositoryUrlProvider)Preconditions.checkNotNull((Object)repositoryUrlProvider);
        this.credentialsProviderFactory = (CredentialsProviderFactory)Preconditions.checkNotNull((Object)credentialsProviderFactory);
        this.taskProgressStore = (TaskProgressStore)Preconditions.checkNotNull((Object)taskProgressStore);
    }

    public void create(Repository repository) throws RepositoryInitializationException {
        if (this.isFileBasedRepository(repository)) {
            if (!new File(repository.getPath()).exists()) {
                LOGGER.warn("Creating repository '" + repository.getName() + "', but given path '" + repository.getPath() + "' does not exist");
            }
            LOGGER.debug("Pointing to existing 'file' based Git repository");
        } else {
            File repositoryDirectory = this.directoryProvider.getLocalDirectory(repository);
            this.create(repository, repositoryDirectory);
        }
    }

    private void create(Repository repository, File localDirectory) throws RepositoryInitializationException {
        String uri = this.repositoryUrlProvider.getUrl(repository);
        try {
            CloneCommand cloneCommand = Git.cloneRepository().setNoCheckout(true).setCloneAllBranches(true).setURI(uri).setDirectory(localDirectory);
            cloneCommand.setProgressMonitor((ProgressMonitor)new TaskProgressMonitor(repository, this.taskProgressStore));
            this.setCredentials((TransportCommand)cloneCommand, repository);
            cloneCommand.setCloneAllBranches(true).call();
        }
        catch (GitAPIException | JGitInternalException e) {
            LOGGER.error("Failed to clone repository: " + uri, e);
            this.rollbackCreatedDirectory(localDirectory);
            throw new RepositoryInitializationException(repository.getName(), uri, e);
        }
    }

    private boolean hasCommitId(GitAttachment attachment) {
        return attachment.getCommitId() != null;
    }

    public Map<GitAttachment, List<DiffEntry>> update(Repository repository) throws RepositoryUpdateException {
        try {
            Git gitRepo = this.openGitRepo(repository);
            if (!this.isFileBasedRepository(repository)) {
                FetchCommand fetchCommand = gitRepo.fetch();
                fetchCommand.setRemoveDeletedRefs(true);
                fetchCommand.setTagOpt(TagOpt.FETCH_TAGS);
                this.setCredentials((TransportCommand)fetchCommand, repository);
                fetchCommand.call();
            }
            HashMap<GitAttachment, List<DiffEntry>> changesPerAttachment = new HashMap<GitAttachment, List<DiffEntry>>();
            Map<Boolean, List<GitAttachment>> gitAttachments = Arrays.stream(repository.getGitAttachments()).collect(Collectors.groupingBy(this::hasCommitId));
            List<GitAttachment> attachmentsWithCommitId = gitAttachments.get(true);
            List<GitAttachment> attachmentsWithoutCommitId = gitAttachments.get(false);
            if (attachmentsWithoutCommitId != null) {
                for (GitAttachment attachment : attachmentsWithoutCommitId) {
                    try {
                        LOGGER.warn("Could not find a commitId for attachment {} try to find it now", (Object)attachment.getID());
                        FileDetails fileDetails = this.getFileDetails(attachment.getRepository(), attachment.getBranch(), attachment.getCommitId(), attachment.getFilePath());
                        attachment.setCommitId(fileDetails.getCommitId().getName());
                        attachment.save();
                    }
                    catch (BranchNotFoundException e) {
                        LOGGER.warn("Failed to find a commitId for attachment {} on branch {} this means the attachment is gone", (Object)attachment.getID(), (Object)attachment.getBranch());
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to fix attachment without commit id " + attachment.getFilePath(), (Throwable)e);
                    }
                }
            }
            if (attachmentsWithCommitId != null) {
                for (GitAttachment attachment : attachmentsWithCommitId) {
                    ObjectId oldHead = ObjectId.fromString((String)attachment.getCommitId());
                    Ref ref = gitRepo.getRepository().exactRef(attachment.getBranch());
                    if (ref == null) {
                        LOGGER.warn("Failed to find ref " + attachment.getBranch() + ". Possibly does not exist anymore");
                        continue;
                    }
                    ObjectId newBranchHead = ref.getObjectId();
                    if (oldHead.equals((AnyObjectId)newBranchHead)) continue;
                    AbstractTreeIterator oldTreeParser = GitRepositoryManager.prepareTreeParser(gitRepo.getRepository(), oldHead);
                    AbstractTreeIterator newTreeParser = GitRepositoryManager.prepareTreeParser(gitRepo.getRepository(), newBranchHead);
                    List diffs = gitRepo.diff().setOldTree(oldTreeParser).setNewTree(newTreeParser).setPathFilter((TreeFilter)PathFilter.create((String)attachment.getFilePath())).call();
                    if (diffs.isEmpty()) continue;
                    changesPerAttachment.put(attachment, diffs);
                }
            }
            return changesPerAttachment;
        }
        catch (IOException | GitAPIException e) {
            LOGGER.error("Failed to update repository: " + repository.getName(), e);
            throw new RepositoryUpdateException(e);
        }
    }

    public String getCommitId(Repository repository, String branch) throws IOException {
        Git git = this.openGitRepo(repository);
        return git.getRepository().findRef(branch).getObjectId().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractTreeIterator prepareTreeParser(org.eclipse.jgit.lib.Repository repository, ObjectId objectId) throws IOException {
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
        RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
        CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
        try (ObjectReader oldReader = repository.newObjectReader();){
            oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
        }
        walk.dispose();
        return oldTreeParser;
    }

    private void setCredentials(TransportCommand transportCommand, Repository repository) {
        Optional<CredentialsProvider> optionalCredentials = this.credentialsProviderFactory.getCredentialsProvider(repository.getServer());
        if (optionalCredentials.isPresent()) {
            transportCommand.setCredentialsProvider(optionalCredentials.get());
        }
    }

    public void delete(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        if (!this.isFileBasedRepository(repository)) {
            File directory = this.directoryProvider.getLocalDirectory(repository);
            try {
                FileUtils.delete((File)directory, (int)1);
            }
            catch (IOException e) {
                LOGGER.warn("Tried to delete folder on location {}, does it exist?", (Object)directory.getAbsoluteFile());
            }
        }
    }

    public void reset(Repository repository) throws RepositoryInitializationException {
        if (!this.isFileBasedRepository(repository)) {
            File repositoryDirectory = this.directoryProvider.getLocalDirectory(repository);
            File cloneDirectory = new File(repositoryDirectory.getParentFile(), repository.getID() + "-clone");
            this.create(repository, cloneDirectory);
            this.delete(repository);
            try {
                Files.move((File)cloneDirectory, (File)repositoryDirectory);
            }
            catch (IOException e) {
                LOGGER.error("Unable to replace old clone directory with new clone", (Throwable)e);
            }
        }
    }

    private void rollbackCreatedDirectory(File localDirectory) {
        try {
            FileUtils.delete((File)localDirectory, (int)1);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete failed local clone directory %s", (Object)localDirectory.getAbsolutePath());
        }
    }

    public FileDetails getFileDetails(Repository repository, String branch, String rawCommitId, String path) throws IOException {
        TreeWalk treeWalk = this.getTreeWalk(repository, branch, rawCommitId);
        treeWalk.setRecursive(true);
        treeWalk.setFilter((TreeFilter)PathFilter.create((String)path));
        if (!treeWalk.next()) {
            LOGGER.error("File with path " + path + " does not exist in repository " + repository.getID() + " in branch " + branch);
            throw new GitFileNotFoundException(new I18nMessage("gitplugin.macro.viewfile.filenotreadable", new Serializable[]{path}));
        }
        ObjectId objectId = treeWalk.getObjectId(0);
        ObjectLoader objectLoader = treeWalk.getObjectReader().open((AnyObjectId)objectId);
        Git git = this.openGitRepo(repository);
        ObjectId commitId = rawCommitId == null || rawCommitId.equals("null") || rawCommitId.trim().isEmpty() ? this.getRefForBranch(git.getRepository(), branch).getObjectId() : ObjectId.fromString((String)rawCommitId);
        return new FileDetails((InputStream)objectLoader.openStream(), objectLoader.getSize(), commitId);
    }

    public Collection<String> getBranches(Repository repository) throws ListRepositoryBranchesException {
        List allBranches;
        Git git;
        try {
            git = this.openGitRepo(repository);
        }
        catch (IOException e) {
            throw new ListRepositoryBranchesException(repository, (Throwable)e);
        }
        try {
            allBranches = git.getRepository().isBare() ? git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call() : git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        }
        catch (GitAPIException e) {
            throw new ListRepositoryBranchesException(repository, (Throwable)e);
        }
        HashSet<String> localBranches = new HashSet<String>();
        for (Ref ref : allBranches) {
            localBranches.add(ref.getName());
        }
        return localBranches;
    }

    public Collection<String> getTags(Repository repository) throws ListRepositoryBranchesException {
        List allTags;
        Git git;
        try {
            git = this.openGitRepo(repository);
        }
        catch (IOException e) {
            throw new ListRepositoryBranchesException(repository, (Throwable)e);
        }
        try {
            allTags = git.tagList().call();
        }
        catch (GitAPIException e) {
            throw new ListRepositoryBranchesException(repository, (Throwable)e);
        }
        HashSet<String> localTags = new HashSet<String>();
        for (Ref ref : allTags) {
            localTags.add(ref.getName());
        }
        return localTags;
    }

    public int getCommitsCount(Repository repository, String branch) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        return Iterables.size((Iterable)git.log().add((AnyObjectId)gitRepository.resolve(branch)).call());
    }

    public String getSearchedCommit(Repository repository, String branch, String term) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        for (RevCommit commit : git.log().add((AnyObjectId)gitRepository.resolve(branch)).call()) {
            if (!commit.getName().equals(term)) continue;
            return commit.getName();
        }
        return null;
    }

    public Collection<String> getCommits(Repository repository, String branch, int maxCount, int start) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        ArrayList<String> commits = new ArrayList<String>();
        for (RevCommit commit : git.log().setMaxCount(maxCount).setSkip((start - 1) * maxCount).add((AnyObjectId)gitRepository.resolve(branch)).call()) {
            commits.add(commit.getName());
        }
        return commits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listFilesInDirectory(Repository repository, String branch, String commitId, String path) throws IOException {
        TreeWalk tw = this.getTreeWalk(repository, branch, commitId);
        ArrayList<String> paths = new ArrayList<String>();
        path = CharMatcher.anyOf((CharSequence)"/").trimFrom((CharSequence)path);
        try {
            if (!StringUtils.isEmpty((CharSequence)path)) {
                PathFilter f = PathFilter.create((String)path);
                tw.setFilter((TreeFilter)f);
                tw.setRecursive(false);
                boolean foundFolder = false;
                while (tw.next()) {
                    if (!foundFolder && tw.isSubtree()) {
                        tw.enterSubtree();
                    }
                    if (tw.getPathString().equals(path)) {
                        foundFolder = true;
                        continue;
                    }
                    if (!foundFolder) continue;
                    paths.add(this.treeWalkItemToString(tw));
                }
            } else {
                tw.setRecursive(false);
                while (tw.next()) {
                    paths.add(this.treeWalkItemToString(tw));
                }
            }
        }
        finally {
            tw.close();
        }
        return paths;
    }

    public Long getLastCommitTimeStamp(Repository repository) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        Iterator iterator = git.log().all().setMaxCount(1).call().iterator();
        if (iterator.hasNext()) {
            return ((RevCommit)iterator.next()).getAuthorIdent().getWhen().getTime();
        }
        return 0L;
    }

    public Set<String> getChangedFilePaths(Repository repository, Long after) throws GitAPIException, IOException {
        Git git = this.openGitRepo(repository);
        List allRefs = git.getRepository().getRefDatabase().getRefs();
        try (RevWalk revWalk = new RevWalk(git.getRepository());){
            revWalk.setRevFilter(CommitTimeRevFilter.after((long)after));
            revWalk.sort(RevSort.COMMIT_TIME_DESC);
            revWalk.sort(RevSort.TOPO, true);
            for (Ref ref : allRefs) {
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)ref.getObjectId()));
            }
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            HashSet changedFiles = new HashSet();
            RevCommit previousCommit = null;
            for (RevCommit commit : revWalk) {
                if (previousCommit != null) {
                    oldTreeIter.reset(revWalk.getObjectReader(), (AnyObjectId)commit.getTree().getId());
                    newTreeIter.reset(revWalk.getObjectReader(), (AnyObjectId)previousCommit.getTree().getId());
                    List diffs = git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setShowNameAndStatusOnly(true).call();
                    changedFiles.addAll(diffs.stream().filter(diff -> diff.getChangeType() != DiffEntry.ChangeType.ADD).map(DiffEntry::getOldPath).collect(Collectors.toSet()));
                }
                previousCommit = commit;
            }
            revWalk.dispose();
            HashSet hashSet = changedFiles;
            return hashSet;
        }
    }

    private boolean isFileBasedRepository(Repository repository) {
        return Server.ConnectionProtocol.FILE.equals((Object)repository.getServer().getConnectionProtocol());
    }

    private Git openGitRepo(Repository repository) throws IOException {
        File localDirectory = this.directoryProvider.getLocalDirectory(repository);
        return Git.open((File)localDirectory);
    }

    private TreeWalk getTreeWalk(Repository repository, String branch, String rawCommitId) throws IOException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        ObjectId commitId = rawCommitId == null || rawCommitId.equals("null") || rawCommitId.trim().isEmpty() ? this.getRefForBranch(gitRepository, branch).getObjectId() : ObjectId.fromString((String)rawCommitId);
        RevWalk revWalk = new RevWalk(gitRepository);
        RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
        TreeWalk tw = new TreeWalk(gitRepository);
        tw.addTree((AnyObjectId)commit.getTree());
        return tw;
    }

    private Ref getRefForBranch(org.eclipse.jgit.lib.Repository gitRepository, String branchName) throws IOException {
        Ref ref = gitRepository.exactRef(branchName);
        if (ref == null) {
            throw new BranchNotFoundException(new I18nMessage("gitplugin.macro.viewfile.branchnotfound", new Serializable[]{branchName}));
        }
        return ref;
    }

    private String treeWalkItemToString(TreeWalk treeWalk) {
        if (treeWalk.isSubtree()) {
            return treeWalk.getPathString() + "/";
        }
        return treeWalk.getPathString();
    }

    public String normalizeRef(String name) {
        return name.replace("refs/tags/", "").replace("refs/heads/", "").replace("refs/remotes/origin/", "");
    }

    public void deriveBranchAndCommitIdFromUrl(GitInformation gitInformation, Repository repository, String uriSource) throws ListRepositoryBranchesException, IOException, GitAPIException {
        Collection<String> branches = this.getBranches(repository);
        List result = branches.stream().filter(b -> uriSource.contains(b.replace("refs/remotes/origin/", "/") + "/")).collect(Collectors.toList());
        if (result.isEmpty()) {
            HashMap<String, String> information = new HashMap<String, String>(this.lookForCommitIdFromUrl(repository, uriSource));
            if (information.size() == 0) {
                LOGGER.warn("Could not find branch or commitId. Check if repository is up-to-date.");
            }
            gitInformation.setBranch((String)information.get("branch"));
            gitInformation.setCommitId((String)information.get("commitId"));
        } else if (result.size() == 1) {
            gitInformation.setBranch((String)result.get(0));
            gitInformation.setCommitId("");
        }
    }

    public void derivePathFromUrl(GitInformation gitInformation, Repository repository, String uriSource) throws IOException {
        String path = "";
        boolean folder = true;
        while (folder) {
            folder = false;
            ArrayList<String> files = new ArrayList<String>(this.listFilesInDirectory(repository, gitInformation.getBranch(), gitInformation.getCommitId(), path));
            List pathList = files.stream().filter(f -> uriSource.contains("/" + f) && !f.contains(".")).collect(Collectors.toList());
            if (pathList.toString() != path && !pathList.isEmpty()) {
                folder = true;
            } else {
                pathList = files.stream().filter(f -> uriSource.contains("/" + f) && f.contains(".")).collect(Collectors.toList());
            }
            if (pathList.isEmpty()) continue;
            path = pathList.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
        }
        gitInformation.setPath(path);
    }

    public Map<String, String> lookForCommitIdFromUrl(Repository repository, String urlSource) throws IOException, GitAPIException {
        urlSource.replace("https://", "/");
        String[] urlParts = urlSource.split("/");
        HashMap<String, String> gitInformation = new HashMap<String, String>();
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        List branches = git.branchList().call();
        for (Ref branch : branches) {
            String branchName = branch.getName();
            Iterable commits = git.log().add((AnyObjectId)gitRepository.resolve(branchName)).call();
            ArrayList commitsList = Lists.newArrayList(commits.iterator());
            block1: for (RevCommit commit : commitsList) {
                for (int i = 0; i < urlParts.length; ++i) {
                    if (!commit.getName().equals(urlParts[i])) continue;
                    gitInformation.put("branch", branchName);
                    gitInformation.put("commitId", commit.getName());
                    continue block1;
                }
            }
        }
        return gitInformation;
    }

    public CommitInformation getCommitInformation(Repository repository, String branch, String path, String commitId, CommitInformation commitInformation) throws IOException, GitAPIException {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM, dd, yyyy hh:mm a");
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        if (commitId == null || commitId == "") {
            commitInformation.setCommitid(this.getLatestCommit(repository, branch));
            commitInformation.setHead(true);
        } else {
            commitInformation.setCommitid(commitId);
            commitInformation.setHead(false);
        }
        for (RevCommit commit : git.log().add((AnyObjectId)gitRepository.resolve(branch)).call()) {
            if (!commit.getName().contains(commitInformation.getCommitid())) continue;
            commitInformation.setAuthor(this.getAuthorOfFile(repository, commit, branch, path));
            commitInformation.setTimestamp(formatter.format(commit.getAuthorIdent().getWhen()));
            commitInformation.setTitle(commit.getShortMessage());
            commitInformation.setDescription(commit.getFullMessage().replace(commit.getShortMessage(), ""));
            break;
        }
        return commitInformation;
    }

    private String getAuthorOfFile(Repository repository, RevCommit baseCommit, String branch, String path) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        String author = null;
        for (RevCommit commit : git.log().addPath(path).call()) {
            if (baseCommit.getCommitTime() < commit.getCommitTime()) continue;
            author = commit.getAuthorIdent().getName();
            break;
        }
        if (author != null) {
            return author;
        }
        LOGGER.error("Could not find author of file: {} in branch: {} in repository: {} on commit: {}", (Object[])new String[]{path, branch, repository.getName(), baseCommit.getId().toString()});
        return "Could not find file author";
    }

    public String getLatestCommit(Repository repository, String branch) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        RevCommit youngestCommit = null;
        for (RevCommit commit : git.log().add((AnyObjectId)gitRepository.resolve(branch)).call()) {
            if (youngestCommit != null && commit.getAuthorIdent().getWhen().compareTo(youngestCommit.getAuthorIdent().getWhen()) <= 0) continue;
            youngestCommit = commit;
        }
        return youngestCommit.getName();
    }

    public List<String> getRepositoryDirectory(Repository repository, String branch, String commitId, String path) throws IOException, GitAPIException {
        Git git = this.openGitRepo(repository);
        org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
        ArrayList<String> directory = new ArrayList<String>();
        if (commitId == null || commitId == "") {
            commitId = this.getLatestCommit(repository, branch);
        }
        if (path.equals("/")) {
            path = "";
        }
        int folderDept = path.length() - path.replace("/", "").length();
        for (RevCommit commit : git.log().add((AnyObjectId)gitRepository.resolve(branch)).call()) {
            if (!commit.getName().contains(commitId)) continue;
            RevTree tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(gitRepository);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                if (!treeWalk.getPathString().startsWith(path)) continue;
                int currentFolderDept = treeWalk.getPathString().length() - treeWalk.getPathString().replace("/", "").length();
                if (folderDept == currentFolderDept) {
                    if (treeWalk.getPathString().contains(".")) {
                        directory.add(treeWalk.getPathString().replace(path, ""));
                        continue;
                    }
                    directory.add(treeWalk.getPathString() + "/");
                    continue;
                }
                if (folderDept + 1 != currentFolderDept) continue;
                String[] dividedPathString = treeWalk.getPathString().split("/");
                boolean isDouble = false;
                for (int i = 0; i < directory.size(); ++i) {
                    if (!((String)directory.get(i)).equals(dividedPathString[folderDept] + "/")) continue;
                    isDouble = true;
                }
                if (isDouble) continue;
                directory.add(dividedPathString[folderDept] + "/");
            }
        }
        return directory;
    }
}

