/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

@Named
public class GitPluginSshCredentialsProvider
extends CredentialsProvider {
    private final ServerService serverService;

    @Inject
    public GitPluginSshCredentialsProvider(@Nonnull ServerService serverService) {
        this.serverService = (ServerService)Preconditions.checkNotNull((Object)serverService);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.StringType) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        Optional<Server> optional = this.serverService.getByHost(uri.getHost());
        if (optional.isPresent()) {
            Server server = optional.get();
            for (CredentialItem item : items) {
                if (!(item instanceof CredentialItem.StringType)) continue;
                this.handleStringTypeCredentialItem(server, (CredentialItem.StringType)item);
            }
        }
        return true;
    }

    private void handleStringTypeCredentialItem(Server server, CredentialItem.StringType item) {
        if (server.getConnectionProtocol().equals((Object)Server.ConnectionProtocol.SSH)) {
            item.setValue(server.getPassword());
        }
    }
}

