/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.service;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ServerDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import nl.avisi.confluence.plugins.gitplugin.exceptions.GitAddonException;
import nl.avisi.confluence.plugins.gitplugin.git.providers.LocalDirectoryProvider;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ServerServiceImpl
implements ServerService {
    private static final Logger LOG = LoggerFactory.getLogger(ServerServiceImpl.class);
    private final ServerDao serverDao;
    private final RepositoryService repositoryService;
    private final LocalDirectoryProvider localDirectoryProvider;

    @Inject
    public ServerServiceImpl(@Nonnull ServerDao serverDao, @Nonnull RepositoryService repositoryService, @Nonnull LocalDirectoryProvider localDirectoryProvider) {
        this.serverDao = (ServerDao)Preconditions.checkNotNull((Object)serverDao);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.localDirectoryProvider = (LocalDirectoryProvider)Preconditions.checkNotNull((Object)localDirectoryProvider);
    }

    @Override
    public Server createServer(String name, ServerInfo serverInfo, ServerAuthentication serverAuthentication) {
        return this.serverDao.createServer(name, serverInfo, serverAuthentication);
    }

    @Override
    public void update(Server server, String name, ServerInfo serverInfo, ServerAuthentication serverAuthentication) {
        if (Server.ConnectionProtocol.FILE.equals((Object)server.getConnectionProtocol())) {
            throw new GitAddonException("'File' based Git servers cannot be updated");
        }
        this.serverDao.update(server, name, serverInfo, serverAuthentication);
    }

    @Override
    public List<Server> all() {
        return this.serverDao.findAll();
    }

    @Override
    public Optional<Server> get(int id) {
        return this.serverDao.get(id);
    }

    @Override
    public Optional<Server> getByHost(String urlHost) {
        Optional<Server> server = this.serverDao.getByHost(urlHost);
        if (!server.isPresent()) {
            LOG.warn("No matching server was found for urlHost: {}", (Object)urlHost);
        }
        return server;
    }

    @Override
    public void delete(Server server) {
        if (Server.ConnectionProtocol.FILE.equals((Object)server.getConnectionProtocol())) {
            throw new GitAddonException("'File' based Git servers cannot be deleted");
        }
        for (Repository repository : server.getRepositories()) {
            this.repositoryService.delete(repository.getID());
        }
        this.serverDao.delete(server);
        File directory = this.localDirectoryProvider.getLocalDirectory(server);
        try {
            FileUtils.delete((File)directory, (int)5);
        }
        catch (IOException e) {
            LOG.warn("Could not delete folder on location {}, does it exist?", (Object)directory.getAbsoluteFile());
        }
    }
}

