/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.I18nMessage;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RepositoryNotFoundException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ServerNotFoundException;

@Named
public class Utils {
    private final ServerService serverService;
    private final RepositoryService repositoryService;

    @Inject
    public Utils(ServerService serverService, RepositoryService repositoryService) {
        this.serverService = serverService;
        this.repositoryService = repositoryService;
    }

    public Repository repositoryIdToRepository(String repositoryId) {
        Optional optional = this.repositoryService.get(Integer.parseInt(repositoryId));
        if (!optional.isPresent()) {
            throw new RepositoryNotFoundException(new I18nMessage("gitplugin.repository.nonexisting"));
        }
        return (Repository)optional.get();
    }

    public Server serverIdToServer(String repositoryId) {
        Optional<Server> optional = this.serverService.get(Integer.parseInt(repositoryId));
        if (!optional.isPresent()) {
            throw new ServerNotFoundException(new I18nMessage("gitplugin.server.nonexisting"));
        }
        return optional.get();
    }
}

