/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.AddServer;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestServer;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.Utils;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.validation.ServerValidator;

@Named
@Path(value="/servers")
@Produces(value={"application/json"})
public class ServerResource
extends LicenseCheckBaseResource {
    private final ServerService serverService;
    private final ServerValidator serverValidator;
    private final Utils utils;

    @Inject
    public ServerResource(ServerService serverService, LicenseChecker licenseChecker, ServerValidator serverValidator, Utils utils) {
        super(licenseChecker);
        this.serverService = (ServerService)Preconditions.checkNotNull((Object)serverService);
        this.serverValidator = (ServerValidator)Preconditions.checkNotNull((Object)serverValidator);
        this.utils = utils;
    }

    @GET
    public Response all() {
        this.checkLicense();
        return Response.ok(RestServer.collection(this.serverService.all())).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response save(AddServer addServer, @Context UriInfo uriInfo) {
        this.checkLicense();
        this.serverValidator.validateForSave(addServer);
        Server server = this.serverService.createServer(addServer.getName(), addServer.getServerInfo(), addServer.getServerAuthentication());
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(server.getID())).build(new Object[0])).entity((Object)new RestServer(server)).build();
    }

    @PUT
    @Path(value="{serverId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response update(@PathParam(value="serverId") String serverId, AddServer addServer) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        this.serverValidator.validateForUpdate(addServer);
        if (addServer.hasMaskedPassword()) {
            addServer.getServerAuthentication().setPassword(server.getPassword());
        }
        this.serverService.update(server, addServer.getName(), addServer.getServerInfo(), addServer.getServerAuthentication());
        return Response.ok().build();
    }

    @GET
    @Path(value="{serverId}")
    public Response get(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        return Response.ok((Object)new RestServer(server)).build();
    }

    @DELETE
    @Path(value="{serverId}")
    @WebSudoRequired
    public Response delete(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        this.serverService.delete(server);
        return Response.ok().build();
    }

    @GET
    @Path(value="{serverId}/repositories")
    public Response getRepositoriesForServer(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        return Response.ok(RestRepository.collection(Lists.newArrayList((Object[])server.getRepositories()))).build();
    }

    @GET
    @Path(value="by-host")
    public Response serverByUrlHost(@QueryParam(value="urlHost") String urlHost) {
        this.checkLicense();
        Optional<Server> optServer = this.serverService.getByHost(urlHost);
        if (optServer.isPresent()) {
            Server server = optServer.get();
            return Response.ok((Object)server.getID()).build();
        }
        return Response.status((int)404).build();
    }
}

