/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestAllBranches;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestDirectoryOrFile;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestGitAttachment;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.Utils;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;
import nl.avisi.confluence.plugins.gitplugin.git.exception.ListRepositoryBranchesException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.GitRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.validation.RepositoryValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tika.Tika;
import org.eclipse.jgit.api.errors.GitAPIException;

@Named
@Path(value="/repositories")
public class RepositoryResource
extends LicenseCheckBaseResource {
    private final RepositoryService repositoryService;
    private final GitRepositoryManager gitRepositoryManager;
    private final AttachmentManager attachmentManager;
    private final I18nResolver i18nResolver;
    private final RepositoryValidator repositoryValidator;
    private final Utils utils;
    private Tika tika;

    @Inject
    public RepositoryResource(@Nonnull RepositoryService repositoryService, @Nonnull GitRepositoryManager gitRepositoryManager, @Nonnull LicenseChecker licenseChecker, @Nonnull AttachmentManager attachmentManager, @Nonnull I18nResolver i18nResolver, @Nonnull RepositoryValidator repositoryValidator, @Nonnull Utils utils) {
        super(licenseChecker);
        this.gitRepositoryManager = (GitRepositoryManager)Preconditions.checkNotNull((Object)gitRepositoryManager);
        this.attachmentManager = (AttachmentManager)Preconditions.checkNotNull((Object)attachmentManager);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.repositoryValidator = (RepositoryValidator)Preconditions.checkNotNull((Object)repositoryValidator);
        this.utils = utils;
        this.tika = new Tika();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRepositories() {
        this.checkLicense();
        Collection repositories = this.repositoryService.getRepositories(true);
        return Response.ok(RestRepository.collection(repositories)).build();
    }

    @GET
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="repositoryId") String repositoryId) {
        this.checkLicense();
        return Response.ok((Object)new RestRepository(this.utils.repositoryIdToRepository(repositoryId))).build();
    }

    @PUT
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response update(RestRepository restRepository, @PathParam(value="repositoryId") String repositoryId) throws RepositoryInitializationException {
        this.checkLicense();
        this.repositoryValidator.validate(restRepository);
        this.repositoryService.update(this.utils.repositoryIdToRepository(repositoryId), restRepository.getName(), restRepository.getPath());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response delete(@PathParam(value="repositoryId") String repositoryId) {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        int attachmentsAmount = repository.getGitAttachments().length;
        if (attachmentsAmount > 0) {
            return Response.status((int)422).entity((Object)new RestError(this.i18nResolver.getText("gitplugin.repository.linkedattachments", new Serializable[]{Integer.valueOf(attachmentsAmount)}))).build();
        }
        this.repositoryService.delete(repository.getID());
        return Response.ok().build();
    }

    @POST
    @Path(value="{serverId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response save(RestRepository restRepository, @PathParam(value="serverId") String serverId) throws RepositoryInitializationException {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        this.repositoryValidator.validate(restRepository);
        Repository createdRepository = this.repositoryService.create(server, restRepository.getName(), restRepository.getPath());
        return Response.ok((Object)new RestRepository(createdRepository)).build();
    }

    @GET
    @Path(value="{repositoryId}/branches-and-tags-autocomplete")
    @Produces(value={"application/json"})
    public RestAllBranches allBranches(@PathParam(value="repositoryId") String repositoryId) throws ListRepositoryBranchesException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        List<RestAllBranches.TagOrBranch> branches = this.repositoryService.getBranches(repository).stream().map(repositoryName -> new RestAllBranches.TagOrBranch((String)repositoryName, this.gitRepositoryManager.normalizeRef((String)repositoryName))).collect(Collectors.toList());
        RestAllBranches.Group branchesGroup = new RestAllBranches.Group("Branches", branches);
        List<RestAllBranches.TagOrBranch> tags = this.repositoryService.getTags(repository).stream().map(tagName -> new RestAllBranches.TagOrBranch((String)tagName, this.gitRepositoryManager.normalizeRef((String)tagName))).collect(Collectors.toList());
        RestAllBranches.Group tagsGroup = new RestAllBranches.Group("Tags", tags);
        ArrayList<RestAllBranches.Group> results = new ArrayList<RestAllBranches.Group>();
        if (!branchesGroup.getChildren().isEmpty()) {
            results.add(branchesGroup);
        }
        if (!tagsGroup.getChildren().isEmpty()) {
            results.add(tagsGroup);
        }
        return new RestAllBranches(results);
    }

    @GET
    @Path(value="{repositoryId}/commits")
    @Produces(value={"application/json"})
    public Response allCommits(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="branch") String branch, @QueryParam(value="term") String term, @QueryParam(value="itemsPerPage") int maxCount, @QueryParam(value="page") int start) throws IOException, GitAPIException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        return Response.ok((Object)this.repositoryService.getCommits(repository, branch, term, maxCount, start)).build();
    }

    @GET
    @Path(value="{repositoryId}/files")
    @Produces(value={"application/json"})
    public Response autoComplete(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        return Response.ok((Object)this.repositoryService.listFilesInDirectory(repository, branch, commitId, path)).build();
    }

    @GET
    @Path(value="{repositoryId}/folders")
    @Produces(value={"application/json"})
    public Response autoCompleteFolder(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        Collection temp = this.repositoryService.listFilesInDirectory(repository, branch, commitId, path);
        Set result = temp.stream().filter(x -> x.endsWith("/")).collect(Collectors.toSet());
        return Response.ok(result).build();
    }

    @GET
    @Path(value="{repositoryId}/listDir")
    @Produces(value={"application/json"})
    public List<RestDirectoryOrFile> listDir(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path, @QueryParam(value="baseurl") String baseUrl) throws IOException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        branch = URLDecoder.decode(branch, "UTF-8");
        path = StringEscapeUtils.unescapeHtml4((String)path);
        List sList = (List)this.repositoryService.listFilesInDirectory(repository, branch, commitId, path);
        ArrayList<RestDirectoryOrFile> foldersAndFiles = new ArrayList<RestDirectoryOrFile>();
        for (String s : sList) {
            String HTMLEncodedS = StringEscapeUtils.escapeHtml4((String)s);
            if (s.endsWith("/")) {
                foldersAndFiles.add(new RestDirectoryOrFile(HTMLEncodedS, StringEscapeUtils.escapeHtml4((String)s.replaceAll("^(.*\\/)*(.*\\/)", "$2")), RestDirectoryOrFile.Type.folder, true));
                continue;
            }
            foldersAndFiles.add(new RestDirectoryOrFile(HTMLEncodedS, "<a href=" + this.attachmentUrlBuilder(repository, baseUrl, branch, s) + " target=\"_blank\">" + StringEscapeUtils.escapeHtml4((String)(s.contains("/") & !s.endsWith("/") ? StringUtils.substringAfterLast((String)s, (String)"/") : s)) + "</a>", RestDirectoryOrFile.Type.file, false));
        }
        return foldersAndFiles;
    }

    private String attachmentUrlBuilder(Repository repository, String baseUrl, String branch, String path) {
        UriBuilder builder = UriBuilder.fromPath((String)(baseUrl + repository.getID())).path("/attachment").queryParam("branch", new Object[]{branch}).queryParam("path", new Object[]{path});
        return builder.build(new Object[]{branch, path}).toString();
    }

    @GET
    @Path(value="{repositoryId}/attachment")
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response attachmentInputStream(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        String mimeType = this.tika.detect(path);
        String response = mimeType.toLowerCase().split("/")[0].equals("image") ? mimeType : "text/plain";
        return Response.ok((Object)this.repositoryService.getInputStream(repository, branch, commitId, path), (String)response).build();
    }

    @GET
    @Path(value="{repositoryId}/attachments")
    @Produces(value={"application/json"})
    public Response attachments(@PathParam(value="repositoryId") String repositoryId) {
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        ArrayList attachments = Lists.newArrayList((Object[])repository.getGitAttachments());
        List restAttachments = attachments.stream().map(this::gitAttachmentToRestGitAttachment).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Response.ok(restAttachments).build();
    }

    private Optional<RestGitAttachment> gitAttachmentToRestGitAttachment(GitAttachment attachment) {
        Attachment confluenceAttachment = this.attachmentManager.getAttachment(attachment.getAttachmentId());
        if (confluenceAttachment != null) {
            return Optional.of(new RestGitAttachment(attachment, confluenceAttachment));
        }
        return Optional.empty();
    }

    @GET
    @Path(value="by-path")
    @Produces(value={"application/json"})
    public Response repositoryByPath(@QueryParam(value="repositoryPath") String repositoryPath) {
        this.checkLicense();
        List repositories = this.repositoryService.findByPath(repositoryPath);
        if (repositories.size() == 1) {
            Repository repository = (Repository)repositories.get(0);
            return Response.ok((Object)repository.getID()).build();
        }
        if (repositories.isEmpty()) {
            return Response.status((int)404).build();
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="{repositoryId}/collect-macro-information")
    @Produces(value={"application/json"})
    public Response collectMacroInformation(@PathParam(value="repositoryId") String repositoryId, @QueryParam(value="uriSource") String uriSource) throws ListRepositoryBranchesException, IOException, GitAPIException {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        return Response.ok((Object)this.repositoryService.getGitInformation(repository, uriSource)).build();
    }

    @POST
    @Path(value="{repositoryId}/actions/archive")
    @Produces(value={"application/json"})
    public Response archive(@PathParam(value="repositoryId") String repositoryId) {
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        this.repositoryService.archive(repository.getID());
        return Response.ok().build();
    }

    @POST
    @Path(value="{repositoryId}/actions/unarchive")
    @Produces(value={"application/json"})
    public Response unarchive(@PathParam(value="repositoryId") String repositoryId) {
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        this.repositoryService.unarchive(repository.getID());
        return Response.ok().build();
    }
}

