(function ($) {

    $.fn.gitPluginCommitSelect = function (options) {
        var $element = this;
        var fittingCharacters = function () {
            return ($element.parent().width() / 10);
        };

        var settings = $.extend({
            branch: function () {
                return "master";
            },
            repository: function () {
                $.error("the repository: fn() argument is required");
            }
        }, options);
        $element.auiSelect2({
            placeholder: AJS.I18n.getText("gitplugin.attachment.dialog.commit.select"),
            minimumInputLength: 0,
            width: "100%",
            closeOnSelect: false,
            adaptContainerCssClass: function (clazz) {
                // filter out macro-param-input for macro browser issues
                if (clazz === "macro-param-input") {
                    return null
                }
                return clazz;
            },
            sortResults: function (results, container, query) {
                if (query.term) {
                    return results.sort(function (a, b) {
                        var aLower = a.text.toLowerCase().indexOf(query.term.toLowerCase());
                        var bLower = b.text.toLowerCase().indexOf(query.term.toLowerCase());
                        if (aLower < bLower) {
                            return 1;
                        } else if (aLower > bLower) {
                            return -1;
                        } else {
                            return 0;
                        }
                    });
                }
                return results;
            },
            ajax: {
                url: function () {
                    return AJS.contextPath() + "/rest/git-plugin/1.0/repositories/" + settings.repository() + "/commits"
                },
                dataType: 'json',
                type: 'GET',
                data: function (term, page) {
                    return {
                        "branch": settings.branch().trim(),
                        "term": term,
                        "itemsPerPage": 100,
                        "page": page || 1
                    };
                },
                results: function (results, page) {
                    var commits = [];
                    var total;
                    results.forEach(function (results) {
                        if (results.search(/[A-Za-z]+/g) != -1) {
                            commits.push({id: results, text: results});
                        } else {
                            total = parseInt(results);
                        }
                    })
                    return {results: commits, more: (page * 100) < total};
                },
            },
        });

        if (!_.isEmpty(settings.initialValue)) {
            $element.auiSelect2("data", {id: settings.initialValue, text: settings.initialValue});
        }

        return this;
    }

}(AJS.$));