/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.confluence.cluster.ClusterManager;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ActiveObjectsServerDao;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLocalGitServerTask
implements ActiveObjectsUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLocalGitServerTask.class);
    private final ClusterManager clusterManager;

    public CreateLocalGitServerTask(@Nonnull ClusterManager clusterManager) {
        this.clusterManager = (ClusterManager)Preconditions.checkNotNull((Object)clusterManager);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"100500303");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        LOG.info("Starting Git 'Local server' migration");
        if (this.clusterManager.isClustered()) {
            LOG.warn("'File' based Git servers are not supported on clustered Confluence instances. Aborting Git 'Local server' migration");
        } else {
            ActiveObjectsServerDao serverDao = new ActiveObjectsServerDao(activeObjects);
            ServerInfo serverInfo = new ServerInfo(Server.ConnectionProtocol.FILE, "/", null);
            serverDao.createServer("Local server", serverInfo, new ServerAuthentication(Server.AuthenticationMethod.NO_AUTHENTICATION, null, null, null));
        }
    }
}

