/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git;

import java.util.Optional;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.stereotype.Component;

@Component
public class CredentialsProviderFactory {
    public Optional<CredentialsProvider> getCredentialsProvider(Server server) {
        if (!this.needsUsernamePasswordCredentialsProvider(server.getConnectionProtocol())) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((CharSequence)server.getPassword()) || StringUtils.isBlank((CharSequence)server.getUsername())) {
            return Optional.empty();
        }
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(server.getUsername(), server.getPassword().toCharArray());
        return Optional.of(credentialsProvider);
    }

    private boolean needsUsernamePasswordCredentialsProvider(Server.ConnectionProtocol connectionProtocol) {
        return connectionProtocol == Server.ConnectionProtocol.HTTP || connectionProtocol == Server.ConnectionProtocol.HTTPS;
    }
}

