/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.compat;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import nl.avisi.confluence.plugins.compat.ConfluencePlatformApi;
import nl.avisi.confluence.plugins.compat.domain.CompatSearchResult;
import nl.avisi.confluence.plugins.compat.utils.ComponentAccessor;
import nl.avisi.confluence.plugins.gitplugin.extractor.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Confluence8PlatformApiImpl
implements ConfluencePlatformApi {
    public static Integer BATCH_SIZE = 1000;
    private final SearchManager searchManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(Confluence8PlatformApiImpl.class);

    public Confluence8PlatformApiImpl(ComponentAccessor componentAccessor) {
        this.searchManager = componentAccessor.getComponent(SearchManager.class);
    }

    @Override
    public List<CompatSearchResult> findPagesWithEmbeddedFiles(int repositoryId, Collection<String> updatedPaths) {
        List searchFilters = updatedPaths.stream().map(path -> new TermQuery("gfc-repository-and-path", Utils.createRepositoryPlusPathValue(repositoryId, path))).collect(Collectors.toList());
        SearchQuery filter = (SearchQuery)BooleanQuery.builder().addShould(searchFilters).build();
        ContentSearch query = new ContentSearch(filter, (SearchSort)ModifiedSort.DEFAULT, 0, BATCH_SIZE.intValue());
        boolean isDrained = false;
        ArrayList<CompatSearchResult> results = new ArrayList<CompatSearchResult>();
        while (!isDrained) {
            SearchResults search;
            try {
                search = this.searchManager.search((ISearch)query);
            }
            catch (InvalidSearchException e) {
                throw new RuntimeException(e);
            }
            isDrained = search.isLastPage();
            List batch = search.getAll().stream().map(res -> new CompatSearchResult(res.getSpaceKey(), res.getDisplayTitle())).collect(Collectors.toList());
            results.addAll(batch);
            LOGGER.debug("Found a batch of {} pages that have references to the changed files repository={}", (Object)results.size(), (Object)repositoryId);
            if (isDrained) continue;
            LOGGER.debug("Found another batch of pages to update for repository={}", (Object)repositoryId);
            query = search.getNextPageSearch();
        }
        return results;
    }
}

