/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ServerDao;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveObjectsServerDao
implements ServerDao {
    private final ActiveObjects ao;

    @Autowired
    public ActiveObjectsServerDao(@ComponentImport ActiveObjects ao) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
    }

    private Server create(String name, String host, Server.ConnectionProtocol connectionProtocol, @Nullable Integer port) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)host, (Object)"uri cannot be null");
        Server server = (Server)this.ao.create(Server.class, new DBParam[]{new DBParam("NAME", (Object)name), new DBParam("HOST", (Object)host), new DBParam("CONNECTION_PROTOCOL", (Object)connectionProtocol), new DBParam("AUTHENTICATION_METHOD", (Object)Server.AuthenticationMethod.NO_AUTHENTICATION)});
        if (port != null) {
            server.setPort(port);
        }
        return server;
    }

    @Override
    public Server createServer(String name, ServerInfo serverInfo, ServerAuthentication serverAuthentication) {
        Server server = this.create(name, serverInfo.getHost(), serverInfo.getProtocol(), serverInfo.getPort());
        this.setAuthentication(server, serverAuthentication);
        server.save();
        return server;
    }

    @Override
    public void update(Server server, String name, ServerInfo serverInfo, ServerAuthentication serverAuthentication) {
        server.setName(name);
        server.setHost(serverInfo.getHost());
        server.setPort(serverInfo.getPort());
        server.setConnectionProtocol(serverInfo.getProtocol());
        this.setAuthentication(server, serverAuthentication);
        server.save();
    }

    @Override
    public List<Server> findAll() {
        return Lists.newArrayList((Object[])((Server[])this.ao.find(Server.class)));
    }

    @Override
    public Optional<Server> get(int id) {
        Server server = (Server)this.ao.get(Server.class, (Object)id);
        return Optional.ofNullable(server);
    }

    @Override
    public Optional<Server> getByHost(String host) {
        Object[] results = (Server[])this.ao.find(Server.class, Query.select().where("HOST = ?", new Object[]{host}).limit(1));
        if (ArrayUtils.isEmpty((Object[])results)) {
            return Optional.empty();
        }
        return Optional.of(results[0]);
    }

    @Override
    public void delete(Server server) {
        this.ao.delete(new RawEntity[]{server});
    }

    private void setAuthentication(Server server, ServerAuthentication serverAuthentication) {
        server.setAuthenticationMethod(serverAuthentication.getAuthenticationMethod());
        if (Server.AuthenticationMethod.SELECT_PRIVATE_KEY.equals((Object)serverAuthentication.getAuthenticationMethod())) {
            server.setSshKey(serverAuthentication.getPrivateKey());
            server.setUsername(serverAuthentication.getUsername());
            server.setPassword(serverAuthentication.getPassword());
        } else if (Server.AuthenticationMethod.USERNAME_PASSWORD.equals((Object)serverAuthentication.getAuthenticationMethod())) {
            server.setUsername(serverAuthentication.getUsername());
            server.setPassword(serverAuthentication.getPassword());
        }
    }
}

