/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewCodeMacroFacade {
    private final XhtmlContent xhtmlContent;
    private static final HashSet<String> ALLOWED_PARAMETERS = Sets.newHashSet((Object[])new String[]{"language", "title", "collapse", "linenumbers", "firstline", "theme"});

    @Autowired
    public NewCodeMacroFacade(@ComponentImport XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    private boolean isValidParameter(String key) {
        return ALLOWED_PARAMETERS.contains(key);
    }

    private boolean isConfiguredParameter(@Nullable String value) {
        return value != null && !value.isEmpty();
    }

    private String transformParameterToStorageParameter(String key, String value) {
        return "<ac:parameter ac:name=\"" + key + "\">" + value + "</ac:parameter>";
    }

    public String render(Map<String, String> parameters, String plainText, ConversionContext context) throws XhtmlException, XMLStreamException {
        StringBuilder storageParameters = new StringBuilder();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (!this.isValidParameter(parameter.getKey()) || !this.isConfiguredParameter(parameter.getValue())) continue;
            storageParameters.append(this.transformParameterToStorageParameter(parameter.getKey(), parameter.getValue()));
        }
        plainText = plainText.replaceAll("]]>", "]]]]><![CDATA[>");
        return this.xhtmlContent.convertStorageToView("<ac:structured-macro ac:name=\"code\">" + storageParameters.toString() + "<ac:plain-text-body><![CDATA[" + plainText + "]]></ac:plain-text-body></ac:structured-macro>\n", context);
    }
}

