/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.generators.image;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import nl.avisi.confluence.plugins.gitplugin.generators.ImageGenerator;
import org.apache.commons.io.IOUtils;

public class VectorImageGenerator
extends ImageGenerator {
    public VectorImageGenerator(WritableDownloadResourceManager resourceManager) {
        super(resourceManager);
    }

    @Override
    public boolean supportsSvg() {
        return true;
    }

    @Override
    public String generateSvg(InputStream gitSource, Map<String, String> parameters, ConversionContext conversionContext) throws IOException {
        return this.renderSvg(gitSource);
    }

    @Override
    public String generatePng(InputStream gitSource, Map<String, String> parameters, ConversionContext conversionContext) throws IOException {
        return this.renderImage(gitSource);
    }

    private String renderSvg(InputStream gitSource) throws IOException {
        return IOUtils.toString(gitSource, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderImage(InputStream gitSource) throws IOException {
        DownloadResourceWriter writer = this.getExportableResourceOutputStream();
        try (OutputStream outputStream = writer.getStreamForWriting();){
            IOUtils.copy(gitSource, outputStream);
        }
        return "<img src=\"" + writer.getResourcePath() + "\"/>";
    }
}

