/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public abstract class PDCIDFont
implements COSObjectable,
PDFontLike,
PDVectorFont {
    protected final PDType0Font parent;
    private Map<Integer, Float> widths;
    private float defaultWidth;
    private float averageWidth;
    private final Map<Integer, Float> verticalDisplacementY = new HashMap<Integer, Float>();
    private final Map<Integer, Vector> positionVectors = new HashMap<Integer, Vector>();
    private float[] dw2;
    protected final COSDictionary dict;
    private PDFontDescriptor fontDescriptor;

    PDCIDFont(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        this.dict = fontDictionary;
        this.parent = parent;
        this.readWidths();
        this.readVerticalDisplacements();
    }

    private void readWidths() {
        this.widths = new HashMap<Integer, Float>();
        COSArray widths = (COSArray)this.dict.getDictionaryObject(COSName.W);
        if (widths != null) {
            int size = widths.size();
            int counter = 0;
            while (counter < size) {
                COSBase next;
                COSNumber firstCode = (COSNumber)widths.getObject(counter++);
                if ((next = widths.getObject(counter++)) instanceof COSArray) {
                    COSArray array = (COSArray)next;
                    int startRange = firstCode.intValue();
                    int arraySize = array.size();
                    for (int i = 0; i < arraySize; ++i) {
                        COSNumber width = (COSNumber)array.getObject(i);
                        this.widths.put(startRange + i, Float.valueOf(width.floatValue()));
                    }
                    continue;
                }
                COSNumber secondCode = (COSNumber)next;
                COSNumber rangeWidth = (COSNumber)widths.getObject(counter++);
                int startRange = firstCode.intValue();
                int endRange = secondCode.intValue();
                float width = rangeWidth.floatValue();
                for (int i = startRange; i <= endRange; ++i) {
                    this.widths.put(i, Float.valueOf(width));
                }
            }
        }
    }

    private void readVerticalDisplacements() {
        COSArray cosDW2 = (COSArray)this.dict.getDictionaryObject(COSName.DW2);
        if (cosDW2 != null) {
            this.dw2 = new float[2];
            this.dw2[0] = ((COSNumber)cosDW2.get(0)).floatValue();
            this.dw2[1] = ((COSNumber)cosDW2.get(1)).floatValue();
        } else {
            this.dw2 = new float[]{880.0f, -1000.0f};
        }
        COSArray w2 = (COSArray)this.dict.getDictionaryObject(COSName.W2);
        if (w2 != null) {
            for (int i = 0; i < w2.size(); ++i) {
                COSBase next;
                COSNumber c = (COSNumber)w2.get(i);
                if ((next = w2.get(++i)) instanceof COSArray) {
                    COSArray array = (COSArray)next;
                    for (int j = 0; j < array.size(); ++j) {
                        int cid = c.intValue() + j;
                        COSNumber w1y = (COSNumber)array.get(j);
                        COSNumber v1x = (COSNumber)array.get(++j);
                        COSNumber v1y = (COSNumber)array.get(++j);
                        this.verticalDisplacementY.put(cid, Float.valueOf(w1y.floatValue()));
                        this.positionVectors.put(cid, new Vector(v1x.floatValue(), v1y.floatValue()));
                    }
                    continue;
                }
                int first = c.intValue();
                int last = ((COSNumber)next).intValue();
                COSNumber w1y = (COSNumber)w2.get(++i);
                COSNumber v1x = (COSNumber)w2.get(++i);
                COSNumber v1y = (COSNumber)w2.get(++i);
                for (int cid = first; cid <= last; ++cid) {
                    this.verticalDisplacementY.put(cid, Float.valueOf(w1y.floatValue()));
                    this.positionVectors.put(cid, new Vector(v1x.floatValue(), v1y.floatValue()));
                }
            }
        }
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dict;
    }

    public String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    public String getName() {
        return this.getBaseFont();
    }

    @Override
    public PDFontDescriptor getFontDescriptor() {
        COSDictionary fd;
        if (this.fontDescriptor == null && (fd = (COSDictionary)this.dict.getDictionaryObject(COSName.FONT_DESC)) != null) {
            this.fontDescriptor = new PDFontDescriptor(fd);
        }
        return this.fontDescriptor;
    }

    @Override
    public abstract Matrix getFontMatrix();

    public final PDType0Font getParent() {
        return this.parent;
    }

    @Override
    public abstract BoundingBox getBoundingBox() throws IOException;

    private float getDefaultWidth() {
        if (this.defaultWidth == 0.0f) {
            COSNumber number = (COSNumber)this.dict.getDictionaryObject(COSName.DW);
            this.defaultWidth = number != null ? number.floatValue() : 1000.0f;
        }
        return this.defaultWidth;
    }

    private Vector getDefaultPositionVector(int cid) {
        return new Vector(this.getWidthForCID(cid) / 2.0f, this.dw2[0]);
    }

    private float getWidthForCID(int cid) {
        Float width = this.widths.get(cid);
        if (width == null) {
            width = Float.valueOf(this.getDefaultWidth());
        }
        return width.floatValue();
    }

    @Override
    public Vector getPositionVector(int code) {
        int cid = this.codeToCID(code);
        Vector v = this.positionVectors.get(cid);
        if (v == null) {
            v = this.getDefaultPositionVector(cid);
        }
        return v;
    }

    public float getVerticalDisplacementVectorY(int code) {
        int cid = this.codeToCID(code);
        Float w1y = this.verticalDisplacementY.get(cid);
        if (w1y == null) {
            w1y = Float.valueOf(this.dw2[1]);
        }
        return w1y.floatValue();
    }

    @Override
    public abstract float getHeight(int var1) throws IOException;

    @Override
    public float getWidth(int code) throws IOException {
        return this.getWidthForCID(this.codeToCID(code));
    }

    @Override
    public abstract float getWidthFromFont(int var1) throws IOException;

    @Override
    public abstract boolean isEmbedded();

    @Override
    public float getAverageFontWidth() {
        if (this.averageWidth == 0.0f) {
            float totalWidths = 0.0f;
            int characterCount = 0;
            if (this.widths != null) {
                for (Float width : this.widths.values()) {
                    if (!(width.floatValue() > 0.0f)) continue;
                    totalWidths += width.floatValue();
                    ++characterCount;
                }
            }
            this.averageWidth = totalWidths / (float)characterCount;
            if (this.averageWidth <= 0.0f || Float.isNaN(this.averageWidth)) {
                this.averageWidth = this.getDefaultWidth();
            }
        }
        return this.averageWidth;
    }

    public PDCIDSystemInfo getCIDSystemInfo() {
        COSDictionary cidSystemInfoDict = (COSDictionary)this.dict.getDictionaryObject(COSName.CIDSYSTEMINFO);
        PDCIDSystemInfo cidSystemInfo = null;
        if (cidSystemInfoDict != null) {
            cidSystemInfo = new PDCIDSystemInfo(cidSystemInfoDict);
        }
        return cidSystemInfo;
    }

    public abstract int codeToCID(int var1);

    public abstract int codeToGID(int var1) throws IOException;

    protected abstract byte[] encode(int var1) throws IOException;
}

