/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ViewGitFileValidator {
    private final I18nResolver i18nResolver;

    @Autowired
    public ViewGitFileValidator(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Set<String> validateFields(Map<String, String> parameters) {
        Optional<Integer> lastline;
        Optional<Integer> firstline;
        try {
            Optional<Integer> tempFirstline = this.safeParseInt(parameters.get("firstline"));
            firstline = tempFirstline.isPresent() ? tempFirstline : Optional.of(1);
            lastline = this.safeParseInt(parameters.get("lastline"));
        }
        catch (NumberFormatException e) {
            return Sets.newHashSet((Object[])new String[]{this.i18nResolver.getText("gitplugin.validation.constraints.digitsOnly.message")});
        }
        HashSet errorMessages = Sets.newHashSet((Object[])new Optional[]{this.checkLastGreaterThanFirst(firstline, lastline), this.checkPosNumber(firstline), this.checkPosNumber(lastline)});
        return this.createErrorMessageSet(errorMessages);
    }

    private Optional<String> checkLastGreaterThanFirst(Optional<Integer> firstline, Optional<Integer> lastline) {
        if (lastline.isPresent() && lastline.get() < firstline.get()) {
            return Optional.of(this.i18nResolver.getText("gitplugin.validation.constraints.lastGreaterThanFirst.message"));
        }
        return Optional.empty();
    }

    private Optional<String> checkPosNumber(Optional<Integer> line) {
        if (line.isPresent() && line.get() < 1) {
            return Optional.of(this.i18nResolver.getText("gitplugin.validation.constraints.minimum.message"));
        }
        return Optional.empty();
    }

    private Optional<Integer> safeParseInt(String number) throws NumberFormatException {
        if (!number.isEmpty()) {
            return Optional.of(Integer.parseInt(number));
        }
        return Optional.empty();
    }

    private Set<String> createErrorMessageSet(Set<Optional<String>> errorMessages) {
        return Sets.newHashSet(errorMessages).stream().filter(validationError -> validationError.isPresent()).map(validationError -> (String)validationError.get()).collect(Collectors.toSet());
    }
}

