/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ValidationError;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.URIish;

public class Validator {
    private final I18nResolver i18nResolver;

    public Validator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Optional<ValidationError> validateNotNull(Object object, String field) {
        if (object == null) {
            return Optional.of(new ValidationError(field, this.i18nResolver.getText("gitplugin.validation.constraints.NotNull.message")));
        }
        return Optional.empty();
    }

    public Optional<ValidationError> validateNotBlank(String string, String field) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return Optional.of(new ValidationError(field, this.i18nResolver.getText("gitplugin.validation.constraints.NotNull.message")));
        }
        return Optional.empty();
    }

    public Optional<ValidationError> validateProtocol(Server.ConnectionProtocol connectionProtocol) {
        if (this.isFileProtocol(connectionProtocol)) {
            return Optional.of(new ValidationError("serverInfo", this.i18nResolver.getText("gitplugin.validation.constraints.Protocol.message")));
        }
        return Optional.empty();
    }

    private boolean isFileProtocol(Server.ConnectionProtocol value) {
        return Server.ConnectionProtocol.FILE.equals((Object)value);
    }

    public Optional<ValidationError> validateHost(String host) {
        URIish uri;
        String errorMessage = this.i18nResolver.getText("gitplugin.validation.constraints.Host.message");
        try {
            uri = new URIish(String.format("%s%s/test", Server.ConnectionProtocol.HTTP.toPrefix(), host));
        }
        catch (URISyntaxException e) {
            return Optional.of(new ValidationError("serverInfo", errorMessage));
        }
        if (uri.getHost() == null) {
            return Optional.of(new ValidationError("serverInfo", errorMessage));
        }
        if (!uri.getHost().equals(host)) {
            return Optional.of(new ValidationError("serverInfo", errorMessage));
        }
        return Optional.empty();
    }

    public Optional<ValidationError> validateRegularExpression(String string, String regex) {
        Pattern regexp = Pattern.compile(regex);
        Matcher matcher = regexp.matcher(string);
        if (!matcher.matches()) {
            return Optional.of(new ValidationError("path", this.i18nResolver.getText("gitplugin.validation.constraints.StartWithSlash.message")));
        }
        return Optional.empty();
    }

    public Set<ValidationError> createValidationErrorSet(Set<Optional<ValidationError>> validationErrors) {
        return Sets.newHashSet(validationErrors).stream().filter(validationError -> validationError.isPresent()).map(validationError -> (ValidationError)validationError.get()).collect(Collectors.toSet());
    }
}

