/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.macro;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ViewMacroHelper {
    private final RepositoryService repositoryService;

    @Autowired
    public ViewMacroHelper(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Optional<Repository> repositoryForMacroRepositoryId(String macroRepositoryId) {
        if (macroRepositoryId.matches("^\\d+$")) {
            int repositoryId = Integer.parseInt(macroRepositoryId);
            return this.repositoryService.get(repositoryId);
        }
        if (macroRepositoryId.split("/").length == 2) {
            String[] components = macroRepositoryId.split("/");
            String repositoryName = components[1];
            String serverName = components[0];
            return this.repositoryService.findByName(repositoryName).stream().filter(repository -> repository.getServer().getName().equals(serverName)).findFirst();
        }
        return Optional.empty();
    }

    public static String getStringSelection(Map<String, String> parameters, InputStream gitSource) {
        int lastline;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(gitSource));
        Stream<String> stream = bufferedReader.lines();
        String lineSeparator = System.getProperty("line.separator");
        String firstLine = Optional.ofNullable(parameters.get("firstline")).orElse("");
        String lastLine = Optional.ofNullable(parameters.get("lastline")).orElse("");
        int firstline = firstLine.isEmpty() ? 0 : Integer.parseInt(firstLine);
        int n = lastline = lastLine.isEmpty() ? 0 : Integer.parseInt(lastLine);
        if (firstline == 0 && lastline == 0) {
            return stream.collect(Collectors.joining(lineSeparator));
        }
        if (firstline == 0) {
            return stream.limit(lastline).collect(Collectors.joining(lineSeparator));
        }
        if (lastline == 0) {
            return stream.skip(firstline - 1).collect(Collectors.joining(lineSeparator));
        }
        return stream.skip(firstline - 1).limit(lastline - firstline + 1).collect(Collectors.joining(lineSeparator));
    }
}

