/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Preconditions;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.utils.ExtractorUtil;
import nl.avisi.confluence.plugins.gitplugin.extentions.CustomResolver;
import nl.avisi.confluence.plugins.gitplugin.generators.image.DigitalImageGenerator;
import nl.avisi.confluence.plugins.gitplugin.generators.image.VectorImageGenerator;
import nl.avisi.confluence.plugins.gitplugin.generators.plantuml.PlantUMLGenerator;
import nl.avisi.confluence.plugins.gitplugin.git.providers.RepositoryUrlProvider;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.license.exception.InvalidLicenseException;
import nl.avisi.confluence.plugins.gitplugin.macro.MacroFunctions;
import nl.avisi.confluence.plugins.gitplugin.macro.NewCodeMacroFacade;
import nl.avisi.confluence.plugins.gitplugin.macro.ViewMacroHelper;
import nl.avisi.confluence.plugins.gitplugin.validation.ViewGitFileValidator;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewGitFileMacro
implements Macro {
    private static final Logger LOG = LoggerFactory.getLogger(ViewGitFileMacro.class);
    private static RepositoryService repositoryService;
    private final I18nResolver i18nResolver;
    private final SecurityService securityService;
    private final LicenseChecker licenseChecker;
    private final NewCodeMacroFacade newCodeMacroFacade;
    private final ViewGitFileValidator viewGitFileValidator;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PageBuilderService pageBuilderService;
    private final SettingsManager settingsManager;
    private final XhtmlContent xhtmlContent;
    private final MacroFunctions macroFunctions;
    private final ViewMacroHelper viewMacroHelper;
    private static Tika tika;
    private WritableDownloadResourceManager exportDownloadResourceManager;

    ViewGitFileMacro(RepositoryService repositoryService, @ComponentImport I18nResolver i18nResolver, SecurityService securityService, LicenseChecker licenseChecker, NewCodeMacroFacade newCodeMacroFacade, ViewGitFileValidator viewGitFileValidator, @ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport SettingsManager settingsManager, @ComponentImport WritableDownloadResourceManager exportDownloadResourceManager, @ComponentImport XhtmlContent xhtmlContent, RepositoryUrlProvider repositoryUrlProvider, ViewMacroHelper viewMacroHelper) {
        this.newCodeMacroFacade = (NewCodeMacroFacade)Preconditions.checkNotNull((Object)newCodeMacroFacade);
        ViewGitFileMacro.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.licenseChecker = (LicenseChecker)Preconditions.checkNotNull((Object)licenseChecker);
        this.viewGitFileValidator = (ViewGitFileValidator)Preconditions.checkNotNull((Object)viewGitFileValidator);
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)soyTemplateRenderer);
        this.pageBuilderService = pageBuilderService;
        this.settingsManager = settingsManager;
        this.xhtmlContent = xhtmlContent;
        this.exportDownloadResourceManager = exportDownloadResourceManager;
        this.macroFunctions = new MacroFunctions(repositoryUrlProvider);
        this.viewMacroHelper = viewMacroHelper;
        tika = new Tika();
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) {
        try {
            this.licenseChecker.validateLicense();
        }
        catch (InvalidLicenseException e) {
            return this.createHtmlErrorMessage(this.i18nResolver.getText(e.getMessage()));
        }
        String macroRepositoryId = parameters.get("repository-id");
        Optional<Repository> optional = this.viewMacroHelper.repositoryForMacroRepositoryId(macroRepositoryId);
        String branch = parameters.get("branch");
        String commitId = parameters.get("commit-id");
        String path = parameters.get("path");
        Boolean renderPanel = Boolean.parseBoolean(parameters.get("renderpanel"));
        Boolean renderPUML = Boolean.parseBoolean(parameters.get("renderpuml"));
        if (!optional.isPresent()) {
            return this.createHtmlMessage(this.i18nResolver.getText("gitplugin.macro.notfound"), this.i18nResolver.getText("gitplugin.macro.viewfile.repositorynotfound", new Serializable[]{macroRepositoryId}));
        }
        Repository repository = optional.get();
        if (!this.securityService.canUse(repository)) {
            return this.createHtmlErrorMessage(this.i18nResolver.getText("gitplugin.macro.viewfile.notallowed"));
        }
        try {
            InputStream gitSource = repositoryService.getInputStream(repository, branch, commitId, path);
            parameters.put("firstline", parameters.getOrDefault("firstline", ""));
            parameters.put("lastline", parameters.getOrDefault("lastline", ""));
            Set<String> errorMessages = this.viewGitFileValidator.validateFields(parameters);
            if (!errorMessages.isEmpty()) {
                return this.createStringSelectionError(errorMessages);
            }
            return this.renderBasedOnFileExtension(gitSource, parameters, context, branch, path, renderPanel, renderPUML, repository, this.macroFunctions.checkForExportingEntity(context));
        }
        catch (UndeclaredThrowableException u) {
            Message errorMessage = ExtractorUtil.getI18nMessageFromException(u);
            return this.createHtmlMessage(this.i18nResolver.getText("gitplugin.macro.notreadable"), this.i18nResolver.getText(errorMessage.getKey(), errorMessage.getArguments()));
        }
        catch (Throwable t) {
            LOG.error("The Git Add-on threw an unexpected exception...", t);
            return this.createHtmlErrorMessage(this.i18nResolver.getText("gitplugin.macro.unexpectederror"));
        }
    }

    public static String detectMimeType(String path) {
        return tika.detect(path).toLowerCase();
    }

    private String getPathExtension(String path) {
        return FilenameUtils.getExtension(path);
    }

    private String renderBasedOnFileExtension(InputStream gitSource, Map<String, String> parameters, ConversionContext context, String branch, String path, Boolean renderPanel, boolean renderPUML, Repository repository, String exporting) throws XhtmlException, XMLStreamException, IOException {
        if (renderPUML) {
            String renderedPUMLImage = new PlantUMLGenerator(this.exportDownloadResourceManager, this.soyTemplateRenderer).generate(gitSource, parameters, context);
            return this.renderWithOptionalRenderPanel(path, renderPanel, repository, renderedPUMLImage, branch, parameters.get("commit-id"), exporting);
        }
        String mineType = ViewGitFileMacro.detectMimeType(path);
        if (mineType.contains("image")) {
            String renderedImage = "";
            renderedImage = mineType.equals("image/svg+xml") ? new VectorImageGenerator(this.exportDownloadResourceManager).generate(gitSource, parameters, context) : new DigitalImageGenerator(this.exportDownloadResourceManager).generate(gitSource, parameters, context);
            return this.renderWithOptionalRenderPanel(path, renderPanel, repository, renderedImage, branch, parameters.get("commit-id"), exporting);
        }
        switch (this.getPathExtension(path)) {
            case "md": {
                String contents = ViewMacroHelper.getStringSelection(parameters, gitSource);
                this.pageBuilderService.assembler().resources().requireContext("nl.avisi.confluence.plugins.git-plugin.view-git-file");
                String renderedContent = this.markdownToHtml(contents, repository.getID(), branch, parameters, context) + "<script>hljs.initHighlightingOnLoad();</script>";
                return this.renderWithOptionalRenderPanel(path, renderPanel, repository, renderedContent, branch, parameters.get("commit-id"), exporting);
            }
        }
        return this.renderDefault(gitSource, parameters, context, path, repository, branch, exporting);
    }

    private String renderWithOptionalRenderPanel(String path, Boolean renderPanel, Repository repository, String renderedContent, String branch, String commitId, String exporting) {
        if (renderPanel.booleanValue()) {
            return this.wrapContentInPanel(repository, branch, commitId, path, "<div class=\"git-plugin-content\">" + renderedContent + "</div> ", exporting);
        }
        return renderedContent;
    }

    private String renderDefault(InputStream gitSource, Map<String, String> parameters, ConversionContext context, String path, Repository repository, String branch, String exporting) throws XhtmlException, XMLStreamException {
        String contents = ViewMacroHelper.getStringSelection(parameters, gitSource);
        String defaultRenderedContent = this.newCodeMacroFacade.render(parameters, contents, context);
        return this.wrapContentInPanel(repository, branch, parameters.get("commit-id"), path, defaultRenderedContent, exporting);
    }

    private String wrapContentInPanel(Repository repository, String branch, String commitId, String path, String content, String exporting) {
        String sourceUri = this.macroFunctions.resolveSourceUri(repository, branch, path, "file");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("repository", repository);
        context.put("exporting", exporting);
        context.put("filename", this.buildFilename(path));
        context.put("fullPath", path);
        context.put("commitInformation", repositoryService.getCommitInformation(repository, branch, path, commitId));
        context.put("contentAsHtml", content);
        if (!sourceUri.isEmpty()) {
            context.put("sourceUri", sourceUri);
        }
        if (exporting.equals("word")) {
            return VelocityUtils.getRenderedTemplate((String)"/views/macro/exportFileMacroWord.vm", context);
        }
        if (exporting.equals("pdf")) {
            return VelocityUtils.getRenderedTemplate((String)"/views/macro/exportFileMacroPDF.vm", context);
        }
        return VelocityUtils.getRenderedTemplate((String)"/views/macro/panel.vm", context);
    }

    private String createHtmlErrorMessage(String body) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"/views/macro/error.vm", context);
    }

    private String createHtmlMessage(String title, String body) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("title", title);
        context.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"/views/macro/message.vm", context);
    }

    private String markdownToHtml(String markdown, int repositoryId, String branch, Map<String, String> parameters, ConversionContext context) {
        markdown = this.stripSectionFromMarkdown(markdown);
        MutableDataSet options = new MutableDataSet();
        ((MutableDataSet)((MutableDataSet)options.set((DataKey)Parser.EXTENSIONS, (Object)Arrays.asList(TocExtension.create(), TablesExtension.create(), AutolinkExtension.create(), AnchorLinkExtension.create(), StrikethroughExtension.create(), CustomResolver.create(this.xhtmlContent, this.settingsManager, parameters, context, repositoryId, branch)))).set((DataKey)TablesExtension.CLASS_NAME, (Object)"aui")).set((DataKey)HtmlRenderer.GENERATE_HEADER_ID, (Object)true);
        Parser parser = Parser.builder(options).build();
        Document document = parser.parse(markdown);
        HtmlRenderer renderer = HtmlRenderer.builder(options).build();
        return renderer.render(document);
    }

    private String stripSectionFromMarkdown(String markdown) {
        Pattern pattern = Pattern.compile("(<!-- #GFCFilterMarkerStart# -->)((?s)(.+?))(<!-- #GFCFilterMarkerEnd# -->)", 32);
        Matcher matcher = pattern.matcher(markdown);
        if (matcher.find()) {
            markdown = markdown.replaceAll(pattern.toString(), "");
        }
        return markdown;
    }

    private String createStringSelectionError(Set<String> errorMessages) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("errorMessages", errorMessages);
        data.put("title", this.i18nResolver.getText("gitplugin.validation.constraints.title"));
        return this.soyTemplateRenderer.render("nl.avisi.confluence.plugins.git-plugin:soy-templates", "Confluence.Templates.ConfigureGitPlugin.viewGitFileErrorMessage", data);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private String buildFilename(String path) {
        String[] resultTextSplit = path.split("/", 0);
        return resultTextSplit[resultTextSplit.length - 1];
    }
}

