/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.generators.plantuml;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import nl.avisi.confluence.plugins.gitplugin.generators.ImageGenerator;
import org.apache.commons.io.IOUtils;

public class PlantUMLGenerator
extends ImageGenerator {
    SoyTemplateRenderer templateRenderer;

    public PlantUMLGenerator(WritableDownloadResourceManager resourceManager, SoyTemplateRenderer templateRenderer) {
        super(resourceManager);
        this.templateRenderer = templateRenderer;
    }

    @Override
    public boolean supportsSvg() {
        return true;
    }

    @Override
    public String generateSvg(InputStream gitSource, Map<String, String> parameters, ConversionContext conversionContext) throws IOException {
        String contents = IOUtils.toString(gitSource, StandardCharsets.UTF_8);
        SourceStringReader reader = new SourceStringReader(contents);
        FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.SVG);
        ArrayList<String> images = new ArrayList<String>();
        for (BlockUml block : reader.getBlocks()) {
            for (int i = 0; i < block.getDiagram().getNbImages(); ++i) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                block.getDiagram().exportDiagram(outputStream, i, fileFormatOption);
                outputStream.close();
                images.add(outputStream.toString("UTF-8"));
            }
        }
        HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
        data.put("images", images);
        return this.templateRenderer.render("nl.avisi.confluence.plugins.git-plugin:soy-templates", "Confluence.Templates.ConfigureGitPlugin.listPlantUMLImagesSvg", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generatePng(InputStream gitSource, Map<String, String> parameters, ConversionContext conversionContext) throws IOException {
        String contents = IOUtils.toString(gitSource, StandardCharsets.UTF_8);
        SourceStringReader reader = new SourceStringReader(contents);
        FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);
        ArrayList<String> images = new ArrayList<String>();
        for (BlockUml block : reader.getBlocks()) {
            for (int i = 0; i < block.getDiagram().getNbImages(); ++i) {
                DownloadResourceWriter writer = this.getExportableResourceOutputStream();
                try (OutputStream outputStream = writer.getStreamForWriting();){
                    block.getDiagram().exportDiagram(outputStream, i, fileFormatOption);
                }
                images.add(writer.getResourcePath());
            }
        }
        HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
        data.put("images", images);
        return this.templateRenderer.render("nl.avisi.confluence.plugins.git-plugin:soy-templates", "Confluence.Templates.ConfigureGitPlugin.listPlantUMLImagesPng", data);
    }
}

