/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.exceptions.utils;

import com.atlassian.sal.api.message.Message;
import nl.avisi.confluence.plugins.gitplugin.I18nMessage;
import nl.avisi.confluence.plugins.gitplugin.exceptions.GitAddonException;
import org.apache.log4j.Logger;

public final class ExtractorUtil {
    private static final Logger LOGGER = Logger.getLogger(ExtractorUtil.class);

    private ExtractorUtil() {
    }

    private static Throwable unwrap(Throwable throwable) {
        if (throwable != null && !(throwable instanceof GitAddonException)) {
            return ExtractorUtil.unwrap(throwable.getCause());
        }
        return throwable;
    }

    public static Message getI18nMessageFromException(Throwable t) {
        Message message;
        Throwable unwrapped = ExtractorUtil.unwrap(t);
        if (unwrapped instanceof GitAddonException && (message = ((GitAddonException)unwrapped).getI18nMessage()) != null) {
            return message;
        }
        LOGGER.warn((Object)"The GIT addon threw an unexpected exception...", t);
        return new I18nMessage("gitplugin.macro.unexpectederror");
    }
}

