/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.core;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class ServerAuthentication {
    @JsonProperty
    private Server.AuthenticationMethod authenticationMethod;
    private String privateKey;
    private String username;
    private String password;

    @JsonCreator
    public ServerAuthentication(@JsonProperty(value="authenticationMethod") @Nonnull Server.AuthenticationMethod authenticationMethod, @JsonProperty(value="privateKey") @Nullable String privateKey, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="password") @Nullable String password) {
        this.authenticationMethod = authenticationMethod;
        this.privateKey = privateKey;
        this.username = username;
        this.password = password;
    }

    @JsonIgnore
    public boolean isUsername() {
        if (this.authenticationMethod == null) {
            return true;
        }
        if (this.authenticationMethod.equals((Object)Server.AuthenticationMethod.USERNAME_PASSWORD)) {
            return StringUtils.isNotBlank((CharSequence)this.username);
        }
        return true;
    }

    @JsonIgnore
    public boolean isPassword() {
        if (this.authenticationMethod == null) {
            return true;
        }
        if (this.authenticationMethod.equals((Object)Server.AuthenticationMethod.USERNAME_PASSWORD)) {
            return StringUtils.isNotBlank((CharSequence)this.password);
        }
        return true;
    }

    @JsonIgnore
    public boolean isPrivateKey() {
        if (this.authenticationMethod == null) {
            return true;
        }
        if (this.authenticationMethod.equals((Object)Server.AuthenticationMethod.SELECT_PRIVATE_KEY)) {
            return StringUtils.isNotBlank((CharSequence)this.privateKey);
        }
        return true;
    }

    public Server.AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @JsonProperty
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            ServerAuthentication otherServerAuthentication = (ServerAuthentication)obj;
            if (!Objects.equal((Object)((Object)this.getAuthenticationMethod()), (Object)((Object)otherServerAuthentication.getAuthenticationMethod()))) {
                return false;
            }
            if (!Objects.equal((Object)this.getPrivateKey(), (Object)otherServerAuthentication.getPrivateKey())) {
                return false;
            }
            if (!Objects.equal((Object)this.getUsername(), (Object)otherServerAuthentication.getUsername())) {
                return false;
            }
            return Objects.equal((Object)this.getPassword(), (Object)otherServerAuthentication.getPassword());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.authenticationMethod, this.privateKey, this.username, this.password});
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

