/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepositoryHealthCheckFailed;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryHealthCheckService;

@Path(value="/health-check")
@Produces(value={"application/json"})
public class RepositoryHealthCheckResource {
    private final RepositoryHealthCheckService repositoryHealthCheckService;

    public RepositoryHealthCheckResource(@Nonnull RepositoryHealthCheckService repositoryHealthCheckService) {
        this.repositoryHealthCheckService = (RepositoryHealthCheckService)Preconditions.checkNotNull((Object)repositoryHealthCheckService);
    }

    @GET
    @Path(value="/check")
    public Response check() {
        return Response.ok(this.repositoryHealthCheckService.check()).build();
    }

    @GET
    @Path(value="/fix")
    public Response fix() {
        List<RestRepositoryHealthCheckFailed> errors = this.repositoryHealthCheckService.fix();
        if (errors.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).build();
    }
}

