/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.compat;

import com.atlassian.plugin.spring.scanner.annotation.component.ClasspathComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import nl.avisi.confluence.plugins.compat.CompatibilityApi;
import nl.avisi.confluence.plugins.compat.Confluence7PlatformApiImpl;
import nl.avisi.confluence.plugins.compat.Confluence8PlatformApiImpl;
import nl.avisi.confluence.plugins.compat.ConfluencePlatformApi;
import nl.avisi.confluence.plugins.compat.errors.CompatibilityError;
import nl.avisi.confluence.plugins.compat.utils.ComponentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={CompatibilityApi.class})
@Component(value="CompatibilityApi")
public class CompatibilityApiFactoryImpl
implements CompatibilityApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatibilityApiFactoryImpl.class);
    private final ApplicationProperties applicationProperties;
    private final ComponentAccessor componentAccessor;

    @Autowired
    public CompatibilityApiFactoryImpl(@ComponentImport ApplicationProperties applicationProperties, @ClasspathComponent ComponentAccessor componentAccessor) {
        this.applicationProperties = applicationProperties;
        this.componentAccessor = componentAccessor;
        LOGGER.info("atlas-compat starting up on={} platform with version={} and platformId={}", new Object[]{this.getPlatformApplicationDisplayName(), this.getPlatformApplicationVersion(), this.getPlatformApplicationId()});
    }

    @Override
    public String getPlatformApplicationId() {
        return this.applicationProperties.getPlatformId();
    }

    @Override
    public String getPlatformApplicationDisplayName() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public String getPlatformApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    @Override
    public boolean isConfluencePlatform() {
        return this.applicationProperties.getPlatformId().equals("conf");
    }

    @Override
    public ConfluencePlatformApi getConfluencePlatformApi() {
        LOGGER.info("Creating confluence platform API {}", (Object)this.getPlatformApplicationVersion());
        if (this.getPlatformApplicationVersion().startsWith("8")) {
            return new Confluence8PlatformApiImpl(this.componentAccessor);
        }
        if (this.getPlatformApplicationVersion().startsWith("7")) {
            return new Confluence7PlatformApiImpl(this.componentAccessor);
        }
        throw new CompatibilityError("Could not find a Confluence platform api for version: " + this.getPlatformApplicationVersion());
    }
}

