/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svg;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;

public final class SvgData {
    private String svg;
    private double startX;
    private double startY;
    private double width;
    private double height;

    public static SvgData fromGraphViz(String s) {
        return new SvgData(SvgData.removeSvgXmlHeader1(s));
    }

    private SvgData(String svg) {
        this.svg = svg;
        this.init();
    }

    private SvgData() {
    }

    private static String removeSvgXmlHeader1(String svg) {
        String newString = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">";
        svg = svg.replaceFirst("(?i)<svg[^>]*>", "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        return svg;
    }

    public SvgData mutateFromSvgTitler(String newSvg, double suppHeight, double suppWidth) {
        SvgData result = new SvgData();
        result.svg = newSvg;
        result.startX = this.startX - suppWidth / 2.0;
        result.startY = this.startY;
        result.width = this.width + suppWidth;
        result.height = this.height + suppHeight;
        return result;
    }

    public final String getSvg() {
        return this.modifiedSvgXmlHeader();
    }

    private void init() {
        Pattern p = Pattern.compile("(?i)<polygon\\s+[^>]*points=\"([^\"]+)\"");
        Matcher m = p.matcher(this.svg);
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        if (!m.find()) {
            return;
        }
        String points = m.group(1);
        StringTokenizer st = new StringTokenizer(points, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(token, ",");
            double x = Double.parseDouble(StringUtils.trin(st2.nextToken()));
            double y = Double.parseDouble(StringUtils.trin(st2.nextToken()));
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        this.width = maxX - minX;
        this.height = maxY - minY;
    }

    private String modifiedSvgXmlHeader() {
        StringBuilder newString = new StringBuilder("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
        newString.append("style=\"width:");
        newString.append(Math.round(this.getWidth()));
        newString.append(";height:");
        newString.append(Math.round(this.getHeight()));
        newString.append(";\" ");
        newString.append("width=\"" + Math.round(this.getWidth()) + "pt\" ");
        newString.append("height=\"" + Math.round(this.getHeight()) + "pt\" ");
        newString.append("viewBox=\"" + Math.round(this.startX) + " " + Math.round(this.startY) + " " + Math.round(this.getWidth()) + " " + Math.round(this.getHeight()) + "\"");
        newString.append(">");
        return this.svg.replaceFirst("(?i)<svg[^>]*>", newString.toString());
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

