/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced1;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class BodierLikeClassOrObject
implements Bodier {
    private final List<CharSequence> rawBody = new ArrayList<CharSequence>();
    private final Set<VisibilityModifier> hides;
    private LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private ILeaf leaf;

    @Override
    public void muteClassToObject() {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.type = LeafType.OBJECT;
    }

    BodierLikeClassOrObject(LeafType type, Set<VisibilityModifier> hides) {
        if (type == LeafType.MAP) {
            throw new IllegalArgumentException();
        }
        this.type = Objects.requireNonNull(type);
        assert (type.isLikeClass() || type == LeafType.OBJECT);
        this.hides = hides;
    }

    @Override
    public void setLeaf(ILeaf leaf) {
        this.leaf = Objects.requireNonNull(leaf);
    }

    @Override
    public boolean addFieldOrMethod(String s) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(s);
        return true;
    }

    private boolean isBodyEnhanced() {
        for (CharSequence s : this.rawBody) {
            if (!BodyEnhanced1.isBlockSeparator(s) && !CreoleParser.isTableLine(s.toString()) && !Parser.isTreeStart(s.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(CharSequence s) {
        String purged = s.toString().replaceAll(UrlBuilder.getRegexp(), "");
        if (purged.contains("{method}")) {
            return true;
        }
        if (purged.contains("{field}")) {
            return false;
        }
        return purged.contains("(") || purged.contains(")");
    }

    @Override
    public Display getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                CharSequence s = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || s.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                Member m = Member.method(s);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Display.create(this.methodsToDisplay);
    }

    private boolean isMethod(int i, List<CharSequence> rawBody) {
        if (i > 0 && i < rawBody.size() - 1 && rawBody.get(i).length() == 0 && this.isMethod(rawBody.get(i - 1)) && this.isMethod(rawBody.get(i + 1))) {
            return true;
        }
        return this.isMethod(rawBody.get(i));
    }

    @Override
    public Display getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (CharSequence s : this.rawBody) {
                if (this.type != LeafType.OBJECT && this.isMethod(s) || s.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                Member m = Member.field(s);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Display.create(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> result) {
        while (result.size() > 0 && StringUtils.trin(result.get(result.size() - 1).getDisplay(false)).length() == 0) {
            result.remove(result.size() - 1);
        }
    }

    @Override
    public boolean hasUrl() {
        Member m;
        for (CharSequence cs : this.getFieldsToDisplay()) {
            if (!(cs instanceof Member) || !(m = (Member)cs).hasUrl()) continue;
            return true;
        }
        for (CharSequence cs : this.getMethodsToDisplay()) {
            if (!(cs instanceof Member) || !(m = (Member)cs).hasUrl()) continue;
            return true;
        }
        return false;
    }

    private List<CharSequence> rawBodyWithoutHidden() {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence s : this.rawBody) {
            Member m = this.isMethod(s) ? Member.method(s) : Member.field(s);
            if (this.hides.contains((Object)m.getVisibilityModifier())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public TextBlock getBody(FontParam fontParam, ISkinParam skinParam, boolean showMethods, boolean showFields, Stereotype stereotype, Style style, FontConfiguration fontConfiguration) {
        if (this.type.isLikeClass() && this.isBodyEnhanced()) {
            if (showMethods || showFields) {
                return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.rawBodyWithoutHidden(), skinParam, stereotype, this.leaf, style);
            }
            return null;
        }
        if (this.leaf == null) {
            throw new IllegalStateException();
        }
        if (this.type == LeafType.OBJECT) {
            if (!showFields) {
                return new TextBlockLineBefore(style.value(PName.LineThickness).asDouble(), TextBlockUtils.empty(0.0, 0.0));
            }
            return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.rawBodyWithoutHidden(), skinParam, stereotype, this.leaf, style);
        }
        assert (this.type.isLikeClass());
        MethodsOrFieldsArea fields = new MethodsOrFieldsArea(this.getFieldsToDisplay(), skinParam, this.leaf, style);
        MethodsOrFieldsArea methods = new MethodsOrFieldsArea(this.getMethodsToDisplay(), skinParam, this.leaf, style);
        if (showFields && !showMethods) {
            return fields.asBlockMemberImpl();
        }
        if (showMethods && !showFields) {
            return methods.asBlockMemberImpl();
        }
        if (!showFields && !showMethods) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock bb1 = fields.asBlockMemberImpl();
        TextBlock bb2 = methods.asBlockMemberImpl();
        return TextBlockUtils.mergeTB(bb1, bb2, HorizontalAlignment.LEFT);
    }

    @Override
    public List<CharSequence> getRawBody() {
        return Collections.unmodifiableList(this.rawBody);
    }
}

