/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class MergeBaseGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int IN_PENDING = 2;
    private static final int POPPED = 16;
    private static final int MERGE_BASE = 8;
    private final RevWalk walker;
    private final DateRevQueue pending;
    private int branchMask;
    private int recarryTest;
    private int recarryMask;
    private int mergeBaseAncestor = -1;
    private LinkedList<RevCommit> ret = new LinkedList();
    private CarryStack stack;
    private static final int CONTINUE = 0;
    private static final int HAVE_ALL = 1;
    private static final int CONTINUE_ON_STACK = 2;

    MergeBaseGenerator(RevWalk w) {
        super(w.isFirstParent());
        this.walker = w;
        this.pending = new DateRevQueue(this.firstParent);
    }

    void init(AbstractRevQueue p) throws IOException {
        try {
            RevCommit c;
            while ((c = p.next()) != null) {
                this.add(c);
            }
            this.recarryTest = this.branchMask | 0x10;
            this.recarryMask = this.branchMask | 0x10 | 8;
            this.mergeBaseAncestor = this.walker.allocFlag();
            while ((c = this._next()) != null) {
                this.ret.add(c);
            }
        }
        finally {
            this.walker.freeFlag(this.branchMask | this.mergeBaseAncestor);
        }
    }

    private void add(RevCommit c) {
        int flag2 = this.walker.allocFlag();
        this.branchMask |= flag2;
        if ((c.flags & this.branchMask) != 0) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().staleRevFlagsOn, c.name()));
        }
        c.flags |= flag2;
        this.pending.add(c);
    }

    @Override
    int outputType() {
        return 0;
    }

    private RevCommit _next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (true) {
            boolean mb;
            if ((c = this.pending.next()) == null) {
                return null;
            }
            RevCommit[] revCommitArray = c.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                if ((p.flags & 2) == 0) {
                    if ((p.flags & 1) == 0) {
                        p.parseHeaders(this.walker);
                    }
                    p.flags |= 2;
                    this.pending.add(p);
                }
                ++n2;
            }
            int carry = c.flags & this.branchMask;
            boolean bl = mb = carry == this.branchMask;
            if (mb) {
                carry |= 8 | this.mergeBaseAncestor;
            }
            this.carryOntoHistory(c, carry);
            if ((c.flags & 8) != 0) {
                if (!this.pending.everbodyHasFlag(8)) continue;
                return null;
            }
            c.flags |= 0x10;
            if (mb) break;
        }
        c.flags |= 8;
        return c;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (!this.ret.isEmpty()) {
            RevCommit commit = this.ret.remove();
            if ((commit.flags & this.mergeBaseAncestor) != 0) continue;
            return commit;
        }
        return null;
    }

    private void carryOntoHistory(RevCommit c, int carry) {
        this.stack = null;
        while (true) {
            this.carryOntoHistoryInnerLoop(c, carry);
            if (this.stack == null) break;
            c = this.stack.c;
            carry = this.stack.carry;
            this.stack = this.stack.prev;
        }
    }

    private void carryOntoHistoryInnerLoop(RevCommit c, int carry) {
        RevCommit[] parents;
        while ((parents = c.getParents()) != null && parents.length != 0) {
            int e = parents.length - 1;
            int i = 0;
            while (i < e) {
                RevCommit p = parents[i];
                if (this.carryOntoOne(p, carry) == 0) {
                    this.stack = new CarryStack(this.stack, p, carry);
                }
                ++i;
            }
            c = parents[e];
            if (this.carryOntoOne(c, carry) == 0) continue;
        }
    }

    private int carryOntoOne(RevCommit p, int carry) {
        int rc = (p.flags & carry) == carry ? 1 : 0;
        p.flags |= carry;
        if ((p.flags & this.recarryMask) == this.recarryTest) {
            p.flags &= 0xFFFFFFEF;
            this.pending.add(p);
            this.stack = new CarryStack(this.stack, p, this.branchMask | 8);
            return 2;
        }
        return rc;
    }

    private static class CarryStack {
        final CarryStack prev;
        final RevCommit c;
        final int carry;

        CarryStack(CarryStack prev, RevCommit c, int carry) {
            this.prev = prev;
            this.c = c;
            this.carry = carry;
        }
    }
}

