/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.exceptions.BranchNotFoundException;
import nl.avisi.confluence.plugins.gitplugin.git.FileDetails;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAttachmentAddCommitIdTask
implements ActiveObjectsUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(GitAttachmentAddCommitIdTask.class);
    private final VCSRepositoryManager repositoryManager;

    public GitAttachmentAddCommitIdTask(@Nonnull VCSRepositoryManager repositoryManager) {
        this.repositoryManager = (VCSRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"100500302");
    }

    public void upgrade(ModelVersion currentVersion, final ActiveObjects ao) {
        LOG.info("Starting Git Attachment 'Commit ID' migration");
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                GitAttachment[] gitAttachments;
                ao.migrate(new Class[]{GitAttachment.class});
                for (GitAttachment gitAttachment : gitAttachments = (GitAttachment[])ao.find(GitAttachment.class)) {
                    try {
                        FileDetails fileDetails = GitAttachmentAddCommitIdTask.this.repositoryManager.getFileDetails(gitAttachment.getRepository(), gitAttachment.getBranch(), gitAttachment.getCommitId(), gitAttachment.getFilePath());
                        gitAttachment.setCommitId(fileDetails.getCommitId().getName());
                        gitAttachment.save();
                        LOG.info("Updated Git Attachment: " + gitAttachment.getID());
                    }
                    catch (IOException | BranchNotFoundException e) {
                        LOG.error("Failed to add commit ID to Git Attachment: " + gitAttachment.getID(), (Throwable)e);
                    }
                }
                return null;
            }
        });
    }
}

