/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.license;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.license.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheckerImpl
implements LicenseChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseChecker.class);
    private static final boolean LICENSE_CHECK_ENABLED = !ConfluenceSystemProperties.isDevMode();
    private final PluginLicenseManager pluginLicenseManager;

    public LicenseCheckerImpl(@ComponentImport @Nonnull PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = (PluginLicenseManager)Preconditions.checkNotNull((Object)pluginLicenseManager);
    }

    @Override
    public void validateLicense() throws InvalidLicenseException {
        if (LICENSE_CHECK_ENABLED) {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                if (pluginLicense.getError().isDefined()) {
                    LicenseError licenseError = (LicenseError)pluginLicense.getError().get();
                    LicenseType licenseType = pluginLicense.getLicenseType();
                    if (licenseType == LicenseType.DEMONSTRATION) {
                        if (licenseError == LicenseError.EXPIRED) {
                            throw new InvalidLicenseException("gitplugin.error.expired-license");
                        }
                    } else if (licenseType != LicenseType.COMMUNITY && licenseType != LicenseType.NON_PROFIT && licenseType != LicenseType.OPEN_SOURCE) {
                        if (licenseError == LicenseError.EXPIRED) {
                            throw new InvalidLicenseException("gitplugin.error.expired-dc-license");
                        }
                        if (licenseError == LicenseError.VERSION_MISMATCH) {
                            throw new InvalidLicenseException("gitplugin.error.version-mismatch");
                        }
                        if (licenseError == LicenseError.TYPE_MISMATCH) {
                            throw new InvalidLicenseException("gitplugin.error.type-mismatch");
                        }
                        if (licenseError == LicenseError.USER_MISMATCH) {
                            throw new InvalidLicenseException("gitplugin.error.user-mismatch");
                        }
                    }
                }
            } else {
                LOG.warn("No license found for the 'Git Add-on'!");
                throw new InvalidLicenseException("gitplugin.error.no-license");
            }
        }
    }
}

