/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.attachment.service;

import com.atlassian.confluence.api.model.content.AttachmentUpload;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Optional;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.GitFileLocationFormatter;
import nl.avisi.confluence.plugins.gitplugin.attachment.dao.GitAttachmentDao;
import nl.avisi.confluence.plugins.gitplugin.attachment.service.GitAttachmentService;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.FileDetails;
import nl.avisi.confluence.plugins.gitplugin.git.manager.GitRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitAttachmentServiceImpl
implements GitAttachmentService {
    private static final Logger LOG = LoggerFactory.getLogger(GitAttachmentServiceImpl.class);
    private final GitAttachmentDao gitAttachmentDao;
    private final AttachmentManager attachmentManager;
    private final AttachmentService attachmentService;
    private final VCSRepositoryManager repositoryManager;
    private final GitRepositoryManager gitRepositoryManager;
    private final I18nResolver i18nResolver;

    @Autowired
    public GitAttachmentServiceImpl(GitAttachmentDao gitAttachmentDao, @ComponentImport AttachmentManager attachmentManager, VCSRepositoryManager repositoryManager, @ComponentImport I18nResolver i18nResolver, GitRepositoryManager gitRepositoryManager, @ComponentImport AttachmentService attachmentService) {
        this.attachmentService = (AttachmentService)Preconditions.checkNotNull((Object)attachmentService);
        this.gitAttachmentDao = (GitAttachmentDao)Preconditions.checkNotNull((Object)gitAttachmentDao);
        this.attachmentManager = (AttachmentManager)Preconditions.checkNotNull((Object)attachmentManager);
        this.repositoryManager = (VCSRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.gitRepositoryManager = (GitRepositoryManager)Preconditions.checkNotNull((Object)gitRepositoryManager);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @Override
    public GitAttachment addToContentEntityObject(ContentEntityObject contentEntityObject, Repository repository, String branch, String commitId, String path) throws IOException {
        Preconditions.checkNotNull((Object)contentEntityObject);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)path);
        FileDetails fileDetails = this.repositoryManager.getFileDetails(repository, branch, commitId, path);
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String attachmentComment = GeneralUtil.shortenString((String)this.i18nResolver.getText("gitplugin.attachment.description", new Serializable[]{GitFileLocationFormatter.format(repository, path), branch}), (int)254);
        File file = File.createTempFile("attachment-", ".tmp");
        file.deleteOnExit();
        Files.copy(fileDetails.getFileContents(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String normalizedBranch = this.gitRepositoryManager.normalizeRef(branch);
        String filename = new File(path).getName();
        AttachmentUpload attachmentUpload = new AttachmentUpload(file, filename, mimeTypesMap.getContentType(filename), attachmentComment, false);
        try {
            PageResponse result = this.attachmentService.addAttachments(contentEntityObject.getContentId(), (Collection)Lists.newArrayList((Object[])new AttachmentUpload[]{attachmentUpload}));
            return this.gitAttachmentDao.save(repository, branch, ((Content)result.getResults().get(0)).getId().asLong(), path, fileDetails.getCommitId().getName());
        }
        catch (ServiceException e) {
            LOG.error("Could not save attachment", (Throwable)e);
            throw e;
        }
    }

    private String generateUniqueFilename(Repository repository, String branch, String path) {
        String filename = new File(path).getName();
        String extension = FilenameUtils.getExtension(filename);
        String baseName = FilenameUtils.getBaseName(filename);
        return baseName + " (" + branch + ") " + this.generateMD5Hash(repository, branch, path).substring(0, 10) + (extension.isEmpty() ? "" : '.' + extension);
    }

    private String generateMD5Hash(Repository repository, String branch, String path) {
        try {
            byte[] bytesOfMessage = (repository.getID() + branch + path).getBytes("UTF-8");
            byte[] result = MessageDigest.getInstance("MD5").digest(bytesOfMessage);
            return String.format("%032X", new BigInteger(1, result));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate unique filename", e);
        }
    }

    @Override
    public void updateAttachment(@Nonnull GitAttachment gitAttachment, @Nonnull String commitId) throws IOException {
        Preconditions.checkNotNull((Object)gitAttachment);
        LOG.debug("Updating attachment: {}", (Object)gitAttachment.getFilePath());
        FileDetails fileDetails = this.repositoryManager.getFileDetails(gitAttachment.getRepository(), gitAttachment.getBranch(), commitId, gitAttachment.getFilePath());
        Attachment attachment = this.attachmentManager.getAttachment(gitAttachment.getAttachmentId());
        if (attachment == null) {
            LOG.warn("Tried to update attachment {}, but the Confluence attachment {} is gone so removing it", (Object)gitAttachment.getFilePath(), (Object)gitAttachment.getAttachmentId());
            this.removeAttachment(gitAttachment);
            return;
        }
        Attachment previousAttachment = attachment.copy();
        previousAttachment.convertToHistoricalVersion();
        previousAttachment.setOriginalVersion((Versioned)attachment);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)attachment.getCreator());
        attachment.setFileSize(fileDetails.getFileSize());
        this.saveAttachment(fileDetails, attachment, previousAttachment);
        gitAttachment.setCommitId(commitId);
        this.gitAttachmentDao.update(gitAttachment);
        LOG.debug("Update complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAttachment(FileDetails fileDetails, Attachment attachment, Attachment previousAttachment) throws IOException {
        try {
            this.attachmentManager.saveAttachment(attachment, previousAttachment, fileDetails.getFileContents());
        }
        finally {
            IOUtils.closeQuietly(fileDetails.getFileContents());
        }
    }

    @Override
    public void removeAttachment(@Nonnull GitAttachment gitAttachment) {
        Preconditions.checkNotNull((Object)gitAttachment);
        LOG.debug("Removing attachment: {}", (Object)gitAttachment.getFilePath());
        Attachment attachment = this.attachmentManager.getAttachment(gitAttachment.getAttachmentId());
        if (attachment != null) {
            this.attachmentManager.removeAttachmentFromServer(attachment);
        } else {
            LOG.warn("Removing git attachment: {}, but could not find it in Confluence. Skip removing attachment from Confluence because it is already gone", (Object)gitAttachment.getCommitId());
        }
        this.gitAttachmentDao.delete(gitAttachment);
    }

    @Override
    public Optional<GitAttachment> get(long attachmentId) {
        return this.gitAttachmentDao.get(attachmentId);
    }
}

