/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.attachment.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.avisi.confluence.plugins.gitplugin.I18nMessage;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.AddGitAttachment;
import nl.avisi.confluence.plugins.gitplugin.attachment.service.GitAttachmentService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.NoAccesToFileException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RepositoryNotFoundException;

@Path(value="/attachments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GitAttachmentResource {
    private final GitAttachmentService gitAttachmentService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final I18nResolver i18nResolver;
    private final PageManager pageManager;

    public GitAttachmentResource(@Nonnull GitAttachmentService gitAttachmentService, @Nonnull RepositoryService repositoryService, @Nonnull SecurityService securityService, @Nonnull I18nResolver i18nResolver, @ComponentImport @Nonnull PageManager pageManager) {
        this.gitAttachmentService = gitAttachmentService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.i18nResolver = i18nResolver;
        this.pageManager = pageManager;
    }

    @POST
    public Response addGitFileToPage(AddGitAttachment addGitAttachment) throws IOException {
        Optional<Repository> optional = this.repositoryService.get(addGitAttachment.getRepositoryId());
        if (!optional.isPresent()) {
            throw new RepositoryNotFoundException(new I18nMessage("gitplugin.macro.viewfile.repositorynotfound", Integer.valueOf(addGitAttachment.getRepositoryId())));
        }
        Repository repository = optional.get();
        if (!this.securityService.canUse(repository)) {
            throw new NoAccesToFileException(this.i18nResolver.getText("gitplugin.macro.viewfile.notallowed"));
        }
        ContentEntityObject contentEntityObject = this.pageManager.getById(addGitAttachment.getContentId());
        GitAttachment attachment = this.gitAttachmentService.addToContentEntityObject(contentEntityObject, repository, addGitAttachment.getBranch(), addGitAttachment.getCommitId(), addGitAttachment.getPath());
        return Response.ok((Object)attachment.getAttachmentId()).build();
    }
}

