/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.version.PSystemKeycheck;
import net.sourceforge.plantuml.version.PSystemKeygen;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(UmlSource source, String line) {
        try {
            Pattern p;
            Matcher m;
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors2(source);
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion2(source);
            }
            if (line.matches("(?i)^stdlib\\s*$")) {
                return PSystemVersion.createStdLib(source);
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot(source);
            }
            if (line.matches("(?i)^keydistributor\\s*$")) {
                return PSystemVersion.createKeyDistributor(source);
            }
            if (line.matches("(?i)^keygen\\s*$")) {
                line = line.trim();
                return new PSystemKeygen(source, "");
            }
            if (line.matches("(?i)^keyimport(\\s+[0-9a-z]+)?\\s*$")) {
                line = line.trim();
                String key = line.substring("keyimport".length()).trim();
                return new PSystemKeygen(source, key);
            }
            if (line.matches("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$") && (m = (p = Pattern.compile("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$")).matcher(line)).find()) {
                return new PSystemKeycheck(source, m.group(1), m.group(2));
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

