/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UFontContext;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.visio.VisioGraphics;

public class DriverTextVdx
implements UDriver<UText, VisioGraphics> {
    private final StringBounder stringBounder;

    public DriverTextVdx(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, VisioGraphics visio) {
        Thread.dumpStack();
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont();
        String text = shape.getText();
        if (text.startsWith(" ")) {
            double space = this.stringBounder.calculateDimension(font, " ").getWidth();
            while (text.startsWith(" ")) {
                x += space;
                text = text.substring(1);
            }
        }
        text = StringUtils.trin(text);
        Dimension2D dim = this.stringBounder.calculateDimension(font, text);
        visio.text(text, x, y, font.getFamily(UFontContext.SVG), font.getSize(), dim.getWidth(), dim.getHeight(), fontConfiguration.getAttributes());
    }
}

