/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.InputStreamSource;
import org.apache.pdfbox.pdfparser.SequentialSource;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDFStreamParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFStreamParser.class);
    private final List<Object> streamObjects = new ArrayList<Object>(100);
    private static final int MAX_BIN_CHAR_TEST_LENGTH = 10;
    private final byte[] binCharTestArr = new byte[10];

    @Deprecated
    public PDFStreamParser(PDStream stream) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
    }

    @Deprecated
    public PDFStreamParser(COSStream stream) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
    }

    public PDFStreamParser(PDContentStream contentStream) throws IOException {
        super(new InputStreamSource(contentStream.getContents()));
    }

    public PDFStreamParser(byte[] bytes) throws IOException {
        super(new InputStreamSource(new ByteArrayInputStream(bytes)));
    }

    public void parse() throws IOException {
        Object token;
        while ((token = this.parseNextToken()) != null) {
            this.streamObjects.add(token);
        }
    }

    public List<Object> getTokens() {
        return this.streamObjects;
    }

    public Object parseNextToken() throws IOException {
        Object retval;
        this.skipSpaces();
        int nextByte = this.seqSource.peek();
        if ((byte)nextByte == -1) {
            return null;
        }
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.seqSource.read();
                c = (char)this.seqSource.peek();
                this.seqSource.unread(leftBracket);
                if (c == '<') {
                    retval = this.parseCOSDictionary();
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    retval = COSNull.NULL;
                    break;
                }
                retval = Operator.getOperator(nullString);
                break;
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                if (next.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                retval = Operator.getOperator(next);
                break;
            }
            case 'R': {
                String line = this.readString();
                if (line.equals("R")) {
                    retval = new COSObject(null);
                    break;
                }
                retval = Operator.getOperator(line);
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dotNotRead;
                StringBuilder buf = new StringBuilder();
                buf.append(c);
                this.seqSource.read();
                if (c == '-' && this.seqSource.peek() == c) {
                    this.seqSource.read();
                }
                boolean bl = dotNotRead = c != '.';
                while (Character.isDigit(c = (char)this.seqSource.peek()) || dotNotRead && c == '.') {
                    buf.append(c);
                    this.seqSource.read();
                    if (!dotNotRead || c != '.') continue;
                    dotNotRead = false;
                }
                retval = COSNumber.get(buf.toString());
                break;
            }
            case 'B': {
                String next = this.readString();
                retval = Operator.getOperator(next);
                if (!next.equals("BI")) break;
                Operator beginImageOP = (Operator)retval;
                COSDictionary imageParams = new COSDictionary();
                beginImageOP.setImageParameters(imageParams);
                Object nextToken = null;
                while ((nextToken = this.parseNextToken()) instanceof COSName) {
                    Object value = this.parseNextToken();
                    imageParams.setItem((COSName)nextToken, (COSBase)value);
                }
                if (!(nextToken instanceof Operator)) break;
                Operator imageData = (Operator)nextToken;
                if (imageData.getImageData() == null || imageData.getImageData().length == 0) {
                    LOG.warn("empty inline image at stream offset " + this.seqSource.getPosition());
                }
                beginImageOP.setImageData(imageData.getImageData());
                break;
            }
            case 'I': {
                String id = "" + (char)this.seqSource.read() + (char)this.seqSource.read();
                if (!id.equals("ID")) {
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "'");
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                if (this.isWhitespace()) {
                    this.seqSource.read();
                }
                int lastByte = this.seqSource.read();
                int currentByte = this.seqSource.read();
                while (!(lastByte == 69 && currentByte == 73 && this.hasNextSpaceOrReturn() && this.hasNoFollowingBinData(this.seqSource) || this.seqSource.isEOF())) {
                    imageData.write(lastByte);
                    lastByte = currentByte;
                    currentByte = this.seqSource.read();
                }
                retval = Operator.getOperator("ID");
                ((Operator)retval).setImageData(imageData.toByteArray());
                break;
            }
            case ']': {
                this.seqSource.read();
                retval = COSNull.NULL;
                break;
            }
            default: {
                String operator = this.readOperator();
                retval = operator.trim().length() == 0 ? null : Operator.getOperator(operator);
            }
        }
        return retval;
    }

    private boolean hasNoFollowingBinData(SequentialSource pdfSource) throws IOException {
        int readBytes = pdfSource.read(this.binCharTestArr, 0, 10);
        boolean noBinData = true;
        int startOpIdx = -1;
        int endOpIdx = -1;
        if (readBytes > 0) {
            String s;
            for (int bIdx = 0; bIdx < readBytes; ++bIdx) {
                byte b = this.binCharTestArr[bIdx];
                if (b < 9 || b > 10 && b < 32 && b != 13) {
                    noBinData = false;
                    break;
                }
                if (startOpIdx == -1 && b != 9 && b != 32 && b != 10 && b != 13) {
                    startOpIdx = bIdx;
                    continue;
                }
                if (startOpIdx == -1 || endOpIdx != -1 || b != 9 && b != 32 && b != 10 && b != 13) continue;
                endOpIdx = bIdx;
            }
            if (!(endOpIdx == -1 || startOpIdx == -1 || "Q".equals(s = new String(this.binCharTestArr, startOpIdx, endOpIdx - startOpIdx)) || "EMC".equals(s) || "S".equals(s))) {
                noBinData = false;
            }
            if (readBytes == 10) {
                if (startOpIdx != -1 && endOpIdx == -1) {
                    endOpIdx = 10;
                }
                if (endOpIdx != -1 && startOpIdx != -1 && endOpIdx - startOpIdx > 3) {
                    noBinData = false;
                }
            }
            pdfSource.unread(Arrays.copyOfRange(this.binCharTestArr, 0, readBytes));
        }
        if (!noBinData) {
            LOG.warn("ignoring 'EI' assumed to be in the middle of inline image");
        }
        return noBinData;
    }

    protected String readOperator() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder(4);
        int nextChar = this.seqSource.peek();
        while (!(nextChar == -1 || this.isWhitespace(nextChar) || this.isClosing(nextChar) || nextChar == 91 || nextChar == 60 || nextChar == 40 || nextChar == 47 || nextChar >= 48 && nextChar <= 57)) {
            char currentChar = (char)this.seqSource.read();
            nextChar = this.seqSource.peek();
            buffer.append(currentChar);
            if (currentChar != 'd' || nextChar != 48 && nextChar != 49) continue;
            buffer.append((char)this.seqSource.read());
            nextChar = this.seqSource.peek();
        }
        return buffer.toString();
    }

    private boolean isSpaceOrReturn(int c) {
        return c == 10 || c == 13 || c == 32;
    }

    private boolean hasNextSpaceOrReturn() throws IOException {
        return this.isSpaceOrReturn(this.seqSource.peek());
    }
}

