/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ValidationError;
import nl.avisi.confluence.plugins.gitplugin.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerAuthenticationValidator
extends Validator {
    @Autowired
    public ServerAuthenticationValidator(@ComponentImport I18nResolver i18nResolver) {
        super(i18nResolver);
    }

    public Set<ValidationError> validate(ServerAuthentication serverAuthentication) {
        Optional<ValidationError> authenticationMethodNotNull;
        Optional<ValidationError> authenticationNotNull = this.validateNotNull(serverAuthentication, "serverAuthentication");
        HashSet validationErrors = !authenticationNotNull.isPresent() ? (!(authenticationMethodNotNull = this.validateServerAuthenticationMethod(serverAuthentication)).isPresent() ? Sets.newHashSet((Object[])new Optional[]{this.validateServerAuthenticationUsername(serverAuthentication), this.validateServerAuthenticationPassword(serverAuthentication), this.validateServerAuthenticationPrivateKey(serverAuthentication)}) : Sets.newHashSet((Object[])new Optional[]{authenticationMethodNotNull})) : Sets.newHashSet((Object[])new Optional[]{authenticationNotNull});
        return this.createValidationErrorSet(validationErrors);
    }

    private Optional<ValidationError> validateServerAuthenticationMethod(ServerAuthentication serverAuthentication) {
        return this.validateNotNull((Object)serverAuthentication.getAuthenticationMethod(), "serverAuthentication-authenticationMethod");
    }

    private Optional<ValidationError> validateServerAuthenticationUsername(ServerAuthentication serverAuthentication) {
        if (serverAuthentication.getAuthenticationMethod() == Server.AuthenticationMethod.USERNAME_PASSWORD) {
            return this.validateNotBlank(serverAuthentication.getUsername(), "serverAuthentication-username");
        }
        return Optional.empty();
    }

    private Optional<ValidationError> validateServerAuthenticationPassword(ServerAuthentication serverAuthentication) {
        if (serverAuthentication.getAuthenticationMethod() == Server.AuthenticationMethod.USERNAME_PASSWORD) {
            return this.validateNotBlank(serverAuthentication.getPassword(), "serverAuthentication-password");
        }
        return Optional.empty();
    }

    private Optional<ValidationError> validateServerAuthenticationPrivateKey(ServerAuthentication serverAuthentication) {
        if (serverAuthentication.getAuthenticationMethod() == Server.AuthenticationMethod.SELECT_PRIVATE_KEY) {
            return this.validateNotBlank(serverAuthentication.getPrivateKey(), "serverAuthentication-privateKey");
        }
        return Optional.empty();
    }
}

