/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.providers.RepositoryUrlProvider;
import nl.avisi.confluence.plugins.gitplugin.macro.ViewGitFileMacro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(ViewGitFileMacro.class);
    private final RepositoryUrlProvider repositoryUrlProvider;

    public MacroFunctions(RepositoryUrlProvider repositoryUrlProvider) {
        this.repositoryUrlProvider = repositoryUrlProvider;
    }

    public String checkForExportingEntity(ConversionContext context) {
        if (context != null && !context.hasProperty("com.k15t.scroll.product.key")) {
            if (context.getOutputType().equals("word")) {
                LOG.debug("Git for Confluence is exporting to word");
                return "word";
            }
            if (context.getOutputType().equals("pdf")) {
                LOG.debug("Git for Confluence is exporting to pdf");
                return "pdf";
            }
        } else if (context != null && context.hasProperty("com.k15t.scroll.product.key")) {
            if (context.getProperty("com.k15t.scroll.product.key").equals("com.k15t.scroll.scroll-office")) {
                LOG.debug("Git for Confluence is exporting to com.k15t.scroll.scroll-office");
                return "word";
            }
            if (context.getProperty("com.k15t.scroll.product.key").equals("com.k15t.scroll.scroll-pdf")) {
                LOG.debug("Git for Confluence is exporting to com.k15t.scroll.scroll-pdf");
                return "pdf";
            }
        }
        return "false";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String resolveSourceUri(Repository repository, String branch, String path, String urlType) {
        String sourceUri = this.repositoryUrlProvider.getUrl(repository).replace(".git", "");
        String normalizedBranch = branch.replace("refs/tags/", "").replace("refs/heads/", "").replace("refs/remotes/origin/", "") + "/";
        if (urlType.equals("file")) {
            if (sourceUri.contains("github")) {
                sourceUri = sourceUri + "/blob/";
                return sourceUri + normalizedBranch + path;
            } else if (sourceUri.contains("bitbucket")) {
                sourceUri = sourceUri + "/src/";
                return sourceUri + normalizedBranch + path;
            } else {
                if (!sourceUri.contains("gitlab")) return "";
                sourceUri = sourceUri + "/-/blob/";
            }
            return sourceUri + normalizedBranch + path;
        } else {
            if (!urlType.equals("folder")) return sourceUri + normalizedBranch + path;
            if (sourceUri.contains("github")) {
                sourceUri = sourceUri + "/tree/";
                return sourceUri + normalizedBranch + path;
            } else if (sourceUri.contains("bitbucket")) {
                sourceUri = sourceUri + "/src/";
                return sourceUri + normalizedBranch + path;
            } else {
                if (!sourceUri.contains("gitlab")) return "";
                sourceUri = sourceUri + "/-/tree/";
            }
        }
        return sourceUri + normalizedBranch + path;
    }
}

