/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.manager;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.CommitInformation;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.GitInformation;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.FileDetails;
import nl.avisi.confluence.plugins.gitplugin.git.exception.ListRepositoryBranchesException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;

public interface VCSRepositoryManager {
    public void create(Repository var1) throws RepositoryInitializationException;

    public Map<GitAttachment, List<DiffEntry>> update(Repository var1) throws RepositoryUpdateException;

    public void delete(Repository var1);

    public void reset(Repository var1) throws RepositoryInitializationException;

    public FileDetails getFileDetails(Repository var1, String var2, String var3, String var4) throws IOException;

    public Collection<String> getBranches(Repository var1) throws ListRepositoryBranchesException;

    public Collection<String> getCommits(Repository var1, String var2, int var3, int var4) throws IOException, GitAPIException;

    public String getSearchedCommit(Repository var1, String var2, String var3) throws IOException, GitAPIException;

    public int getCommitsCount(Repository var1, String var2) throws IOException, GitAPIException;

    public Collection<String> getTags(Repository var1) throws ListRepositoryBranchesException;

    public Collection<String> listFilesInDirectory(Repository var1, String var2, String var3, String var4) throws IOException;

    public String getCommitId(Repository var1, String var2) throws IOException;

    public void deriveBranchAndCommitIdFromUrl(GitInformation var1, Repository var2, String var3) throws ListRepositoryBranchesException, IOException, GitAPIException;

    public Map<String, String> lookForCommitIdFromUrl(Repository var1, String var2) throws IOException, GitAPIException;

    public void derivePathFromUrl(GitInformation var1, Repository var2, String var3) throws IOException;

    public Long getLastCommitTimeStamp(Repository var1) throws IOException, GitAPIException;

    public Set<String> getChangedFilePaths(Repository var1, Long var2) throws GitAPIException, IOException;

    public CommitInformation getCommitInformation(Repository var1, String var2, String var3, String var4, CommitInformation var5) throws IOException, GitAPIException, ParseException;

    public String getLatestCommit(Repository var1, String var2) throws IOException, GitAPIException;

    public List<String> getRepositoryDirectory(Repository var1, String var2, String var3, String var4) throws IOException, GitAPIException;
}

