/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.generators;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import nl.avisi.confluence.plugins.gitplugin.generators.Generator;

public abstract class ImageGenerator
implements Generator {
    private WritableDownloadResourceManager resourceManager;

    public ImageGenerator(WritableDownloadResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public String generate(InputStream gitSource, Map<String, String> parameters, ConversionContext conversionContext) throws IOException {
        if (this.supportsSvg() && this.shouldRenderSvg(conversionContext)) {
            return this.generateSvg(gitSource, parameters, conversionContext);
        }
        return this.generatePng(gitSource, parameters, conversionContext);
    }

    public abstract boolean supportsSvg();

    public abstract String generateSvg(InputStream var1, Map<String, String> var2, ConversionContext var3) throws IOException;

    public abstract String generatePng(InputStream var1, Map<String, String> var2, ConversionContext var3) throws IOException;

    public DownloadResourceWriter getExportableResourceOutputStream() {
        String username = AuthenticatedUserThreadLocal.getUsername();
        return this.resourceManager.getResourceWriter(username, "git-for-confluence", "png");
    }

    public boolean shouldRenderSvg(ConversionContext conversionContext) {
        if (this.isScrollExportingToFormatWithSvgSupport(conversionContext)) {
            return true;
        }
        return !this.isConfluenceExporting(conversionContext);
    }

    public boolean isScrollExportingToFormatWithSvgSupport(ConversionContext conversionContext) {
        String scrollProductKey = conversionContext.getPropertyAsString("com.k15t.scroll.product.key");
        return this.isFormatWithSvgSupport(scrollProductKey);
    }

    private boolean isFormatWithSvgSupport(String scrollProductKey) {
        return "com.k15t.scroll.scroll-pdf".equals(scrollProductKey);
    }

    public boolean isConfluenceExporting(ConversionContext conversionContext) {
        switch (conversionContext.getOutputType()) {
            case "preview": 
            case "display": {
                return false;
            }
        }
        return true;
    }
}

