/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest.providers;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.core.HttpContext;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.ext.Provider;
import nl.avisi.confluence.plugins.gitplugin.I18nMessage;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.providers.AbstractPathParamProvider;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RepositoryNotFoundException;

@Provider
public class RepositoryProvider
extends AbstractPathParamProvider<Repository> {
    private final RepositoryService repositoryService;

    public RepositoryProvider(@Nonnull RepositoryService repositoryService) {
        super(Repository.class);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
    }

    @Override
    public Repository doGetValue(HttpContext context, String parameterValue) {
        int repositoryId = Integer.parseInt(parameterValue);
        Optional<Repository> optional = this.repositoryService.get(repositoryId);
        if (!optional.isPresent()) {
            throw new RepositoryNotFoundException(new I18nMessage("gitplugin.repository.nonexisting"));
        }
        return optional.get();
    }
}

